<?php

declare(strict_types=1);

namespace App\Service\Url;

use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

final readonly class PortalUrlGenerator implements PortalUrlGeneratorInterface
{
    public function __construct(
        private ParameterBagInterface $parameterBag
    )
    {
    }

    public function generateUserPasswordResetUrl(string $token): string
    {
        return $this->getPortalUrl('jelszo-visszaallitas/' . $token);
    }

    private function getPortalUrl(string $path): string
    {
        return rtrim($this->parameterBag->get('portal_url'), '/') . '/' . ltrim($path, '/');
    }

    public function generateUserVerificationUrl(string $token): string
    {
        return $this->getPortalUrl('aktivalas/' . $token);
    }

    public function generateFacebookCallbackUrl(): string
    {
        return $this->getPortalUrl('auth/callback/facebook');
    }

    public function generateGoogleCallbackUrl(): string
    {
        return $this->getPortalUrl('auth/callback/google');
    }

    public function generateSimplePayCallbackUrl(): string
    {
        return $this->getPortalUrl('fizetes');
    }

    public function generatePortalImageUrl(string $fileName): string
    {
        return $this->getPortalUrl('assets/images/email/' . $fileName);
    }
}
