<?php

namespace App\Service\View\EventSubscriber;

use App\Service\View\Event\ResponseCreatedEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class CookieSettingEventSubscriber implements EventSubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
            ResponseCreatedEvent::class => 'handle'
        ];
    }

    public function handle(ResponseCreatedEvent $event): void
    {
        $response = $event->getResponse();
        $context = $event->getContext();

        $cookies = $context->getExtra('cookies', []);

        foreach ($cookies as $cookie) {
            $response->headers->setCookie($cookie);
        }

        $unsetCookies = $context->getExtra('unset_cookies', []);

        foreach ($unsetCookies as $cookie) {
            $response->headers->removeCookie($cookie);
        }
    }
}