<?php

namespace App\Service\View\Serializer\Exception;

use App\Exception\View\ConstraintViolationException;
use App\Exception\View\ManualConstraintViolationException;
use Symfony\Component\Validator\ConstraintViolationInterface;
use Symfony\Component\Validator\Exception\ValidationFailedException;

readonly class ConstraintViolationExceptionNormalizerDecorator implements ExceptionNormalizerInterface
{
    public function __construct(
        private ExceptionNormalizerInterface $normalizer
    )
    {
    }

    public function supportsNormalization(mixed $data, string $format = null, array $context = []): bool
    {
        return $this->normalizer->supportsNormalization($data, $format, $context);
    }

    public function normalize(mixed $object, string $format = null, array $context = []): array
    {
        $data = $this->normalizer->normalize($object, $format, $context);

        $violations = [];

        if ($object instanceof ManualConstraintViolationException) {
            $violations[] = [
                'path' => $object->getPath(),
                'message' => $object->getViolationMessage()
            ];
        } elseif ($object instanceof ConstraintViolationException || $object instanceof ValidationFailedException) {
            /** @var ConstraintViolationInterface $constraintViolationList */
            foreach ($object->getViolations() as $constraintViolationList) {
                $violations[] = [
                    'path' => $constraintViolationList->getPropertyPath(),
                    'message' => (string) $constraintViolationList->getMessage()
                ];
            }
        }

        if (!empty($violations)) {
            $data['meta'] = array_merge($data['meta'] ?? [], [
                'violations' => $violations
            ]);
        }

        return $data;
    }
}