<?php

namespace App\Service\View\Serializer\Exception;

use Symfony\Component\HttpKernel\Exception\HttpExceptionInterface;

readonly class HttpExceptionNormalizerDecorator implements ExceptionNormalizerInterface
{
    public function __construct(
        private ExceptionNormalizerInterface $normalizer
    )
    {
    }

    public function supportsNormalization(mixed $data, string $format = null, array $context = []): bool
    {
        return $this->normalizer->supportsNormalization($data, $format);
    }

    public function normalize(mixed $object, string $format = null, array $context = []): array
    {
        $data = $this->normalizer->normalize($object, $format, $context);

        if ($object instanceof HttpExceptionInterface) {
            $data['status'] = $object->getStatusCode();
        }

        return $data;
    }
}