<?php

declare(strict_types=1);

namespace App\Table\Education;

use App\Table\Abstract\BaseTable;
use Omines\DataTablesBundle\Column\TextColumn;
use Omines\DataTablesBundle\Column\TwigStringColumn;
use Omines\DataTablesBundle\DataTable;

final class LessonTable extends BaseTable
{
    public function configure(DataTable $dataTable, array $options): void
    {
        parent::preConfigure($dataTable, $options);
        $dataTable->add('isHighlighted', TextColumn::class, ['render' => fn($value, $context): string => $this->twig->render('system/components/table/_state.html.twig', [
            'state' => $context->isHighlighted()
        ]), 'searchable' => false]);

        $dataTable->add('category', TwigStringColumn::class, ['template' => '{{ row.translatable.category ? row.translatable.category.title }}', 'searchable' => false]);
        parent::configure($dataTable, $options);
    }
}
