<?php

declare(strict_types=1);

namespace App\Table\User;

use App\Table\Abstract\BaseTable;
use Omines\DataTablesBundle\Column\BoolColumn;
use Omines\DataTablesBundle\Column\TextColumn;
use Omines\DataTablesBundle\Column\TwigColumn;
use Omines\DataTablesBundle\DataTable;

final class UserTable extends BaseTable
{
    public function configure(DataTable $dataTable, array $options): void
    {
        $dataTable
            ->add('name', TextColumn::class, [
                'render' => fn($value, $context): string => $this->twig->render('system/components/table/_blamable.html.twig', [
                    'meta' => ['route_prefix' => $options['prefix']],
                    'user' => $context
                ]),
                'searchable' => false,
                'orderable' => false
            ])
            ->add('email', TextColumn::class)
            ->add('roles', TwigColumn::class, ['template' => 'system/components/table/_role.html.twig', 'searchable' => false])
            ->add('verified', BoolColumn::class, [
                'visible' => false
            ]);

        parent::configure($dataTable, $options);
    }
}
