<?php

declare(strict_types=1);

namespace App\Traits\Entity;

use App\Entity\Common\Address;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

trait Addressable
{
    protected ?Collection $addresses = null;

    public function getAddresses(): ?Collection
    {
        return $this->addresses;
    }

    public function addAddress(Address $address): self
    {
        if ($this->addresses === null) {
            $this->addresses = new ArrayCollection();
        }

        if (!$this->addresses->contains($address)) {
            $this->addresses->add($address);
        }

        return $this;
    }

    public function removeAddress(Address $address): self
    {
        $this->addresses->removeElement($address);

        return $this;
    }
}
