<?php

declare(strict_types=1);

namespace App\Traits\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

trait HighlightedAware
{

    #[ORM\Column(options: ['default' => false])]
    #[Gedmo\Versioned]
    protected bool $isHighlighted = false;


    public function isHighlighted(): bool
    {
        return $this->isHighlighted;
    }

    public function getIsHighlighted(): bool
    {
        return $this->isHighlighted;
    }

    public function setIsHighlighted(bool $isHighlighted): self
    {
        $this->isHighlighted = $isHighlighted;

        return $this;
    }
}
