<?php

declare(strict_types=1);

namespace App\Traits\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

trait MediaAware
{
    #[ORM\Column(length: 255, nullable: true)]
    #[Gedmo\Versioned]
    private ?string $media = null;

    public function getMedia(): ?string
    {
        return $this->media;
    }

    public function setMedia(?string $media): self
    {
        $this->media = $media;

        return $this;
    }
}
