<?php

declare(strict_types=1);

namespace App\Traits\Entity;

use App\Entity\Interfaces\NestedableInterface;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

trait Nestedable
{
    #[Gedmo\SortablePosition]
    #[ORM\Column(name: 'position', type: 'integer')]
    private int $position = 0;

    #[Gedmo\TreeLeft]
    #[ORM\Column(name: 'lft', type: Types::INTEGER)]
    private int $lft;


    #[Gedmo\TreeLevel]
    #[ORM\Column(name: 'lvl', type: Types::INTEGER)]
    private int $lvl;


    #[Gedmo\TreeRight]
    #[ORM\Column(name: 'rgt', type: Types::INTEGER)]
    private int $rgt;


    #[Gedmo\TreeRoot]
    private NestedableInterface|null $root;


    #[Gedmo\TreeParent]
    private NestedableInterface|null $parent;


    private Collection $children;


    public function getPosition(): int
    {
        return $this->position;
    }

    public function setPosition(int $position): void
    {
        $this->position = $position;
    }

    public function getChildren(): Collection
    {
        return $this->children;
    }

    public function setChildren($children): void
    {
        $this->children = $children;
    }

    public function getRoot(): ?NestedableInterface
    {
        return $this->root;
    }

    public function getParent(): ?NestedableInterface
    {
        return $this->parent;
    }

    public function setParent(?NestedableInterface $nestedable): void
    {
        $this->parent = $nestedable;
    }
}
