<?php

declare(strict_types=1);

namespace App\Traits\Entity;

use App\Entity\Common\Tag\Tag;
use Doctrine\Common\Collections\Collection;

trait Tagable
{
    protected ?Collection $tags = null;

    public function getTags(): ?Collection
    {
        return $this->tags;
    }

    public function addTag(Tag $tag): self
    {
        if ($this->tags && !$this->tags->contains($tag)) {
            $this->tags->add($tag);
        }

        return $this;
    }

    public function removeTag(Tag $tag): self
    {
        $this->tags->removeElement($tag);

        return $this;
    }
}
