<?php

declare(strict_types=1);

namespace App\Traits\Entity;

use App\Entity\Interfaces\TranslatableInterface;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

trait Translation
{
    #[ORM\Column(type: Types::STRING, length: 8)]
    protected string $locale;

    /**
     * @var TranslatableInterface
     */
    protected TranslatableInterface $translatable;

    public static function getTranslatableEntityClass(): string
    {
        return substr(static::class, 0, -11);
    }

    public function getTranslatable(): TranslatableInterface
    {
        return $this->translatable;
    }

    public function setTranslatable(TranslatableInterface $translatable): void
    {
        $this->translatable = $translatable;
    }

    public function getLocale(): string
    {
        return $this->locale;
    }

    public function setLocale(string $locale): void
    {
        $this->locale = $locale;
    }

    public function isEmpty(): bool
    {
        foreach (get_object_vars($this) as $var => $value) {
            if (in_array($var, ['id', 'translatable', 'locale'], true)) {
                continue;
            }

            if (is_string($value) && strlen(trim($value)) > 0) {
                return false;
            }

            if (!empty($value)) {
                return false;
            }
        }

        return true;
    }
}
