<?php

declare(strict_types=1);

namespace App\Traits\Entity;

use Doctrine\ORM\Mapping as ORM;

trait Verifiable
{
    #[ORM\Column(type: 'boolean', nullable: false)]
    private bool $verified = false;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $verificationToken = null;

    public function isVerified(): bool
    {
        return $this->verified;
    }

    public function setVerified(bool $verified): void
    {
        $this->verified = $verified;
    }

    public function getVerificationToken(): ?string
    {
        return $this->verificationToken;
    }

    public function setVerificationToken(?string $verificationToken): void
    {
        $this->verificationToken = $verificationToken;
    }

}
