<?php

declare(strict_types=1);

namespace App\Traits\Route;

use App\Transformer\DTO\Cms\NestedTransformer;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

trait TreeAction
{
    #[Route('/tree', name: 'tree')]
    public function treeAction(): Response
    {
        return parent::tree();
    }

    #[Route('/api/tree', name: 'api_tree', methods: ['GET', 'POST'])]
    public function treeApiAction(Request $request, NestedTransformer $nestedTransformer): JsonResponse
    {
        return parent::treeApi($request, $nestedTransformer);
    }
}
