<?php

declare(strict_types=1);

namespace App\Transformer\DTO\Article;

use App\DTO\PublicAPI\Article\Output\ArticleListEntry;
use App\Entity\Magazine\Article\Article;
use App\Transformer\DTO\Shared\MediaTransformer;

final readonly class ArticleListEntryTransformer
{
    public function __construct(
        private MediaTransformer $mediaTransformer
    )
    {
    }

    public function __invoke(Article $article): ArticleListEntry
    {
        $media = $this->mediaTransformer->create(
            $article->getImage()
        );

        return new ArticleListEntry(
            $article->getId(),
            $article->getTitle(),
            $article->getIntro(),
            $article->getSlug(),
            $article->isHighlighted(),
            $article->getPublishedAt(),
            $media
        );
    }
}
