<?php

declare(strict_types=1);

namespace App\Transformer\DTO\Cms;

use App\DTO\Cms\Activity;
use App\Repository\System\Administrator\AdministratorRepository;
use Gedmo\Loggable\Entity\LogEntry;
use Symfony\Component\Serializer\Normalizer\DateTimeNormalizer;
use Symfony\Component\Serializer\SerializerInterface;


final readonly class ActivityTransformer
{
    public function __construct(
        private AdministratorRepository $administratorRepository,
        private SerializerInterface     $serializer
    )
    {
    }

    public function __invoke(LogEntry $logEntry): Activity
    {
        $administrator = $this->administratorRepository->findOneByEmail($logEntry->getUsername());

        $data = $this->serializer->normalize($logEntry->getData(), null, [
            DateTimeNormalizer::FORMAT_KEY => 'Y-m-d H:i:s'
        ]);

        return new Activity(
            $logEntry->getId(),
            $logEntry->getAction(),
            $logEntry->getLoggedAt(),
            $logEntry->getObjectId(),
            $logEntry->getObjectClass(),
            $logEntry->getVersion(),
            $data,
            $administrator ? [
                'id' => $administrator->getId(),
                'email' => $administrator->getEmail(),
                'name' => $administrator->getFullName()
            ] : null,
        );
    }
}
