<?php

declare(strict_types=1);

namespace App\Transformer\DTO\Cms;

use App\DTO\Cms\Nested;
use App\Entity\Shared\AbstractEntity;

final readonly class NestedTransformer
{
    public function __construct(private int $maxDepth = 10)
    {
    }

    public function __invoke(AbstractEntity $nestedable, int $depth = 0): Nested
    {
        if ($depth >= $this->maxDepth) {
            return new Nested($nestedable->getId(), $nestedable->getTitle(), []);
        }

        $children = [];
        foreach ($nestedable->getChildren() as $child) {
            $children[] = $this->__invoke($child, $depth + 1);
        }

        return new Nested($nestedable->getId(), $nestedable->getTitle(), $children);
    }
}


