<?php

declare(strict_types=1);

namespace App\Transformer\DTO\Shared;

use App\DTO\PublicAPI\Shared\Output\Block;
use App\Entity\Common\Layout\Block as BlockEntity;

final readonly class BlockTransformer
{
    public function __construct(
        private MediaTransformer $mediaTransformer
    )
    {
    }

    public function __invoke(BlockEntity $blockEntity): Block
    {
        $media = $this->mediaTransformer->create($blockEntity->getImage());
        return new Block(
            $blockEntity->getTemplate(),
            $blockEntity->getTitle(),
            $blockEntity->getUrl(),
            $blockEntity->getLead(),
            $blockEntity->getDescription(),
            $media,
        );
    }
}
