<?php

declare(strict_types=1);

namespace App\Transformer\DTO\Shared;

use App\DTO\PublicAPI\Shared\Output\Config;
use App\Entity\System\Webspace\Config as ConfigEntity;

final readonly class ConfigTransformer
{
    public function __construct(
        private MediaTransformer $mediaTransformer
    )
    {
    }

    public function __invoke(ConfigEntity $configEntity): Config
    {
        $media = $this->mediaTransformer->create($configEntity->getFile());
        return new Config(
            $configEntity->getKey(),
            $configEntity->getValue(),
            $media
        );
    }
}
