<?php

declare(strict_types=1);

namespace App\Transformer\DTO\Shared;

use App\DTO\PublicAPI\Shared\Output\Faq;
use App\Entity\Common\Support\Faq as FaqEntity;


final readonly class FaqTransformer
{
    public function __invoke(FaqEntity $faqEntity): Faq
    {
        return new Faq(
            $faqEntity->getId(),
            $faqEntity->getQuestion(),
            $faqEntity->getContent(),
        );
    }
}
