<?php

declare(strict_types=1);

namespace App\Transformer\DTO\Shared;

use App\DTO\PublicAPI\Shared\Output\Media;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

final readonly class MediaTransformer
{
    public function __construct(
        private ParameterBagInterface $parameterBag
    )
    {
    }

    public function create(?string $url): ?Media
    {
        if ($url === null) {
            return null;
        }

        return new Media($this->parameterBag->get('app.api_url') . $url);
    }
}
