<?php

declare(strict_types=1);

namespace App\Transformer\DTO\Shared;

use App\DTO\PublicAPI\Shared\Output\Tag;
use App\Entity\Common\Tag\Tag as TagEntity;

final readonly class TagTransformer
{
    public function __construct(
        private MediaTransformer $mediaTransformer
    )
    {
    }

    public function __invoke(TagEntity $tagEntity): Tag
    {
        $media = $this->mediaTransformer->create($tagEntity->getImage());
        return new Tag(
            $tagEntity->getId(),
            $tagEntity->getTitle(),
            $tagEntity->getSlug(),
            $media
        );
    }
}
