<?php

declare(strict_types=1);

namespace App\Transformer\DTO\User;

use App\DTO\PublicAPI\User\Output\UserDetails;
use App\Entity\User\User;

final readonly class UserDetailsTransformer
{
    public function __invoke(User $user): UserDetails
    {
        $userDetails = new UserDetails();
        $userDetails->firstName = $user->getFirstName();
        $userDetails->lastName = $user->getLastName();
        $userDetails->email = $user->getEmail();
        $userDetails->addresses = $user->getAddresses()->isEmpty() ? [] : [$user->getAddresses()->first()->getId()];

        return $userDetails;
    }
}
