<?php

namespace App\Twig;

use App\Service\Url\PortalUrlGeneratorInterface;
use Symfony\Component\Routing\Route;
use Symfony\Component\Routing\RouterInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

final class AppExtension extends AbstractExtension
{
    public function __construct(
        private readonly RouterInterface             $router,
        private readonly PortalUrlGeneratorInterface $portalUrlGenerator
    )
    {
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('route_exists', $this->routeExists(...)),
            new TwigFunction('get_class', $this->getClassName(...)),
            new TwigFunction('portal_image', $this->portalImage(...)),
        ];
    }

    public function routeExists(string $name): bool
    {

        return $this->router->getRouteCollection()->get($name) instanceof Route;
    }

    public function getClassName($object): string
    {
        return str_replace('\\', '/', (string)$object::class);
    }

    public function portalImage(string $fileName): string
    {
        return $this->portalUrlGenerator->generatePortalImageUrl($fileName);
    }
}
