<?php

declare(strict_types=1);

namespace App\Validator\Constraints;

use App\Entity\User\User;
use App\Repository\User\UserRepository;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use Symfony\Component\Validator\Exception\UnexpectedTypeException;

final class EmailNotRegisteredValidator extends ConstraintValidator
{
    public function __construct(
        private readonly UserRepository $userRepository
    )
    {
    }

    public function validate(mixed $value, Constraint $constraint): void
    {
        if (!$constraint instanceof EmailNotRegistered) {
            throw new UnexpectedTypeException($constraint, EmailNotRegistered::class);
        }

        if (null === $value || '' === $value) {
            return;
        }

        if (!is_string($value)) {
            return;
        }

        $user = $this->userRepository->findByEmail($value);

        if (!$user instanceof User) {
            return;
        }

        $this->context
            ->buildViolation($constraint->message)
            ->setParameter('{{ email }}', $value)
            ->addViolation();
    }
}
