<?php

namespace ContainerDxEgRBn;

use Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\ParameterNotFoundException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/**
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class App_KernelProdDebugContainer extends Container
{
    protected $targetDir;
    protected $parameters = [];
    protected \Closure $getService;

    public function __construct(private array $buildParameters = [], protected string $containerDir = __DIR__)
    {
        $this->targetDir = \dirname($containerDir);
        $this->parameters = $this->getDefaultParameters();

        $this->services = $this->privates = [];
        $this->syntheticIds = [
            'kernel' => true,
        ];
        $this->methodMap = [
            'cache.security_is_granted_attribute_expression_language' => 'getCache_SecurityIsGrantedAttributeExpressionLanguageService',
            'doctrine' => 'getDoctrineService',
            'doctrine.dbal.default_connection' => 'getDoctrine_Dbal_DefaultConnectionService',
            'doctrine.orm.default_entity_listener_resolver' => 'getDoctrine_Orm_DefaultEntityListenerResolverService',
            'doctrine.orm.default_entity_manager' => 'getDoctrine_Orm_DefaultEntityManagerService',
            'event_dispatcher' => 'getEventDispatcherService',
            'http_kernel' => 'getHttpKernelService',
            'lexik_translation.translator' => 'getLexikTranslation_TranslatorService',
            'request_stack' => 'getRequestStackService',
            'router' => 'getRouterService',
        ];
        $this->fileMap = [
            'App\\Components\\AgeVerify' => 'getAgeVerifyService',
            'App\\Components\\Cookie' => 'getCookieService',
            'App\\Components\\Search' => 'getSearchService',
            'App\\Controller\\App\\AppController' => 'getAppControllerService',
            'App\\Controller\\App\\LessonController' => 'getLessonControllerService',
            'App\\Controller\\Cms\\CmsController' => 'getCmsControllerService',
            'App\\Controller\\Cms\\Education\\ApplyController' => 'getApplyControllerService',
            'App\\Controller\\Cms\\Education\\BenefitController' => 'getBenefitControllerService',
            'App\\Controller\\Cms\\Education\\CategoryController' => 'getCategoryControllerService',
            'App\\Controller\\Cms\\Education\\ExamController' => 'getExamControllerService',
            'App\\Controller\\Cms\\Education\\LessonController' => 'getLessonController2Service',
            'App\\Controller\\Cms\\ExportController' => 'getExportControllerService',
            'App\\Controller\\Cms\\Magazine\\Article\\ArticleController' => 'getArticleControllerService',
            'App\\Controller\\Cms\\Security\\AdministratorController' => 'getAdministratorControllerService',
            'App\\Controller\\Cms\\Security\\ResetPasswordController' => 'getResetPasswordControllerService',
            'App\\Controller\\Cms\\Security\\SecurityController' => 'getSecurityControllerService',
            'App\\Controller\\Cms\\System\\ActivityController' => 'getActivityControllerService',
            'App\\Controller\\Cms\\System\\AddressController' => 'getAddressControllerService',
            'App\\Controller\\Cms\\System\\CategoryController' => 'getCategoryController2Service',
            'App\\Controller\\Cms\\System\\FaqController' => 'getFaqControllerService',
            'App\\Controller\\Cms\\System\\FileController' => 'getFileControllerService',
            'App\\Controller\\Cms\\System\\MessageController' => 'getMessageControllerService',
            'App\\Controller\\Cms\\System\\PageController' => 'getPageControllerService',
            'App\\Controller\\Cms\\System\\TagController' => 'getTagControllerService',
            'App\\Controller\\Cms\\System\\TopicController' => 'getTopicControllerService',
            'App\\Controller\\Cms\\System\\WebspaceController' => 'getWebspaceControllerService',
            'App\\Controller\\Cms\\User\\UserController' => 'getUserControllerService',
            'App\\Controller\\Portal\\Auth\\Login\\Facebook\\AuthorizationUrlController' => 'getAuthorizationUrlControllerService',
            'App\\Controller\\Portal\\Auth\\Login\\Google\\AuthorizationUrlController' => 'getAuthorizationUrlController2Service',
            'App\\Controller\\Portal\\Auth\\PasswordReset\\ChangeController' => 'getChangeControllerService',
            'App\\Controller\\Portal\\Auth\\PasswordReset\\CheckController' => 'getCheckControllerService',
            'App\\Controller\\Portal\\Auth\\PasswordReset\\RequestController' => 'getRequestControllerService',
            'App\\Controller\\Portal\\Auth\\Registration\\RegisterController' => 'getRegisterControllerService',
            'App\\Controller\\Portal\\Auth\\Verification\\ResendController' => 'getResendControllerService',
            'App\\Controller\\Portal\\Auth\\Verification\\VerifyController' => 'getVerifyControllerService',
            'App\\Controller\\Portal\\Faq\\ListController' => 'getListControllerService',
            'App\\Controller\\Portal\\InitController' => 'getInitControllerService',
            'App\\Controller\\Portal\\Magazine\\Article\\ListController' => 'getListController2Service',
            'App\\Controller\\Portal\\Magazine\\Article\\ViewController' => 'getViewControllerService',
            'App\\Controller\\Portal\\Page\\ViewController' => 'getViewController2Service',
            'App\\Controller\\Portal\\Profile\\DeleteController' => 'getDeleteControllerService',
            'App\\Controller\\Portal\\Profile\\EditController' => 'getEditControllerService',
            'App\\Controller\\Portal\\Profile\\ViewController' => 'getViewController3Service',
            'App\\Controller\\Portal\\System\\AddressController' => 'getAddressController2Service',
            'App\\Controller\\Portal\\System\\TagController' => 'getTagController2Service',
            'Arkounay\\Bundle\\UxMediaBundle\\Controller\\CropController' => 'getCropControllerService',
            'Artgris\\Bundle\\FileManagerBundle\\Controller\\ManagerController' => 'getManagerControllerService',
            'Lexik\\Bundle\\TranslationBundle\\Controller\\RestController' => 'getRestControllerService',
            'Lexik\\Bundle\\TranslationBundle\\Controller\\TranslationController' => 'getTranslationControllerService',
            'Lexik\\Bundle\\TranslationBundle\\Manager\\LocaleManager' => 'getLocaleManagerService',
            'Omines\\DataTablesBundle\\DataTableFactory' => 'getDataTableFactoryService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\RedirectController' => 'getRedirectControllerService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\TemplateController' => 'getTemplateControllerService',
            'cache.app' => 'getCache_AppService',
            'cache.app_clearer' => 'getCache_AppClearerService',
            'cache.global_clearer' => 'getCache_GlobalClearerService',
            'cache.rate_limiter' => 'getCache_RateLimiterService',
            'cache.system' => 'getCache_SystemService',
            'cache.system_clearer' => 'getCache_SystemClearerService',
            'cache.validator_expression_language' => 'getCache_ValidatorExpressionLanguageService',
            'cache_warmer' => 'getCacheWarmerService',
            'console.command.public_alias.Lexik\\Bundle\\TranslationBundle\\Command\\ExportTranslationsCommand' => 'getExportTranslationsCommandService',
            'console.command.public_alias.Lexik\\Bundle\\TranslationBundle\\Command\\ImportTranslationsCommand' => 'getImportTranslationsCommandService',
            'console.command_loader' => 'getConsole_CommandLoaderService',
            'container.env_var_processors_locator' => 'getContainer_EnvVarProcessorsLocatorService',
            'container.get_routing_condition_service' => 'getContainer_GetRoutingConditionServiceService',
            'debug.error_handler_configurator' => 'getDebug_ErrorHandlerConfiguratorService',
            'error_controller' => 'getErrorControllerService',
            'gesdinet.jwtrefreshtoken' => 'getGesdinet_JwtrefreshtokenService',
            'gesdinet.jwtrefreshtoken.refresh_token_generator' => 'getGesdinet_Jwtrefreshtoken_RefreshTokenGeneratorService',
            'gesdinet.jwtrefreshtoken.refresh_token_manager' => 'getGesdinet_Jwtrefreshtoken_RefreshTokenManagerService',
            'gesdinet.jwtrefreshtoken.request.extractor.chain' => 'getGesdinet_Jwtrefreshtoken_Request_Extractor_ChainService',
            'knp_gaufrette.filesystem_map' => 'getKnpGaufrette_FilesystemMapService',
            'knp_paginator' => 'getKnpPaginatorService',
            'knpu.oauth2.client.facebook' => 'getKnpu_Oauth2_Client_FacebookService',
            'knpu.oauth2.client.google' => 'getKnpu_Oauth2_Client_GoogleService',
            'knpu.oauth2.registry' => 'getKnpu_Oauth2_RegistryService',
            'lexik_jwt_authentication.encoder' => 'getLexikJwtAuthentication_EncoderService',
            'lexik_jwt_authentication.generate_token_command' => 'getLexikJwtAuthentication_GenerateTokenCommandService',
            'lexik_jwt_authentication.jwt_manager' => 'getLexikJwtAuthentication_JwtManagerService',
            'lexik_jwt_authentication.key_loader' => 'getLexikJwtAuthentication_KeyLoaderService',
            'lexik_translation.data_grid.formatter' => 'getLexikTranslation_DataGrid_FormatterService',
            'lexik_translation.data_grid.request_handler' => 'getLexikTranslation_DataGrid_RequestHandlerService',
            'lexik_translation.exporter.json' => 'getLexikTranslation_Exporter_JsonService',
            'lexik_translation.exporter.xliff' => 'getLexikTranslation_Exporter_XliffService',
            'lexik_translation.exporter_collector' => 'getLexikTranslation_ExporterCollectorService',
            'lexik_translation.form.handler.trans_unit' => 'getLexikTranslation_Form_Handler_TransUnitService',
            'lexik_translation.importer.file' => 'getLexikTranslation_Importer_FileService',
            'lexik_translation.overview.stats_aggregator' => 'getLexikTranslation_Overview_StatsAggregatorService',
            'lexik_translation.trans_unit.manager' => 'getLexikTranslation_TransUnit_ManagerService',
            'lexik_translation.translation_storage' => 'getLexikTranslation_TranslationStorageService',
            'messenger.default_bus' => 'getMessenger_DefaultBusService',
            'monolog.logger.deprecation' => 'getMonolog_Logger_DeprecationService',
            'routing.loader' => 'getRouting_LoaderService',
            'scheb_two_factor.firewall_context' => 'getSchebTwoFactor_FirewallContextService',
            'scheb_two_factor.form_controller' => 'getSchebTwoFactor_FormControllerService',
            'scheb_two_factor.security.email.code_generator' => 'getSchebTwoFactor_Security_Email_CodeGeneratorService',
            'scheb_two_factor.security.google_authenticator' => 'getSchebTwoFactor_Security_GoogleAuthenticatorService',
            'services_resetter' => 'getServicesResetterService',
            'ux.autocomplete.entity_autocomplete_controller' => 'getUx_Autocomplete_EntityAutocompleteControllerService',
            'ux.live_component.batch_action_controller' => 'getUx_LiveComponent_BatchActionControllerService',
        ];
        $this->aliases = [
            'App\\Kernel' => 'kernel',
            'Lexik\\Bundle\\TranslationBundle\\Manager\\LocaleManagerInterface' => 'Lexik\\Bundle\\TranslationBundle\\Manager\\LocaleManager',
            'database_connection' => 'doctrine.dbal.default_connection',
            'doctrine.orm.entity_manager' => 'doctrine.orm.default_entity_manager',
            'oauth2.registry' => 'knpu.oauth2.registry',
            'translator' => 'lexik_translation.translator',
        ];

        $this->privates['service_container'] = static function ($container) {
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher/EventSubscriberInterface.php';
            include_once \dirname(__DIR__, 4).'/src/EventListener/LocaleSubscriber.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/ResponseListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/LocaleListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/ValidateRequestListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/DisallowRobotsIndexingListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/ErrorListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/CacheAttributeListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/ParameterBagInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/ParameterBag.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/FrozenParameterBag.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/container/src/ContainerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/ContainerBagInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/ContainerBag.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/RunnerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/Runner/Symfony/HttpKernelRunner.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/Runner/Symfony/ResponseRunner.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/RuntimeInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/GenericRuntime.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/SymfonyRuntime.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/HttpKernelInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/TerminableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/HttpKernel.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ControllerResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/TraceableControllerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ControllerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ContainerControllerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/Controller/ControllerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ArgumentResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/TraceableArgumentResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ArgumentResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/service-contracts/ServiceProviderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/service-contracts/ServiceLocatorTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ServiceLocator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/RequestStack.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/config/ConfigCacheFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/config/ResourceCheckerConfigCacheFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/LocaleAwareListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/Formatter/MessageFormatterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/Formatter/IntlFormatterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/Formatter/MessageFormatter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation-contracts/TranslatorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation-contracts/LocaleAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation-contracts/TranslatorTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/IdentityTranslator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/LocaleSwitcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/DebugHandlersListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/service-contracts/ResetInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/stopwatch/Stopwatch.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/RequestContext.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/expression-language/ExpressionFunctionProviderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Matcher/ExpressionLanguageProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/RouterListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Reader.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/AnnotationReader.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/PsrCachedReader.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/cache/src/CacheItemPoolInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/AdapterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache-contracts/CacheInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/PruneableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/ResettableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache-contracts/CacheTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Traits/ContractsTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Traits/ProxyTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/PhpArrayAdapter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-access/PropertyAccessorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-access/PropertyAccessor.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/log/src/LoggerAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/log/src/LoggerAwareTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/ArrayAdapter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/SerializerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/NormalizerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ContextAwareNormalizerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DenormalizerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ContextAwareDenormalizerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/EncoderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/ContextAwareEncoderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/DecoderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/ContextAwareDecoderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Serializer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/SerializerAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/CacheableSupportsMethodInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/SerializerAwareTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/UnwrappingDenormalizer.php';
            include_once \dirname(__DIR__, 4).'/src/Service/View/Serializer/Exception/ExceptionNormalizerInterface.php';
            include_once \dirname(__DIR__, 4).'/src/Service/View/Serializer/Exception/PartialDenormalizationExceptionNormalizerDecorator.php';
            include_once \dirname(__DIR__, 4).'/src/Service/View/Serializer/Exception/HttpExceptionNormalizerDecorator.php';
            include_once \dirname(__DIR__, 4).'/src/Service/View/Serializer/Exception/ConstraintViolationExceptionNormalizerDecorator.php';
            include_once \dirname(__DIR__, 4).'/src/Service/View/Serializer/Exception/AnonymizingExceptionNormalizerDecorator.php';
            include_once \dirname(__DIR__, 4).'/src/Service/View/Serializer/Exception/ExceptionNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/NormalizerAwareTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/messenger/Transport/Serialization/Normalizer/FlattenExceptionNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ProblemNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/UidNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DateTimeNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ConstraintViolationListNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/NameConverter/NameConverterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/NameConverter/AdvancedNameConverterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/NameConverter/MetadataAwareNameConverter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/MimeMessageNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ObjectToPopulateTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/AbstractNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/AbstractObjectNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/PropertyNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/ClassDiscriminatorResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/ClassDiscriminatorFromClassMetadata.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DateTimeZoneNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DateIntervalNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/FormErrorNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/BackedEnumNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DataUriNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/JsonSerializableNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DenormalizerAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DenormalizerAwareTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ArrayDenormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ObjectNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/NormalizationAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/XmlEncoder.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/JsonEncoder.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/YamlEncoder.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/CsvEncoder.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/Factory/ClassResolverTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/Loader/LoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/Loader/LoaderChain.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/Loader/AnnotationLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyTypeExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyDescriptionExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyAccessExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyListExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyInfoExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyInitializableExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyInfoExtractor.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyReadInfoExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyWriteInfoExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/Extractor/ConstructorArgumentTypeExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/Extractor/ReflectionExtractor.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/web-link/HttpHeaderSerializer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/web-link/EventListener/AddLinkHeaderListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/AbstractSessionListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/SessionListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Mapping/Factory/MetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Validator/ValidatorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/ValidatorBuilder.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Validation.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/ConstraintValidatorFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/ContainerConstraintValidatorFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/ObjectInitializerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/doctrine-bridge/Validator/DoctrineInitializer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Mapping/Loader/LoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Mapping/Loader/AutoMappingTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Mapping/Loader/PropertyInfoLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/doctrine-bridge/Validator/DoctrineLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/mime/MimeTypeGuesserInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/mime/MimeTypesInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/mime/MimeTypes.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/ConnectionRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/ManagerRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/AbstractManagerRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/doctrine-bridge/ManagerRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/Registry.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/event-manager/src/EventManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/doctrine-bridge/ContainerAwareEventManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Connection.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/ConnectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Configuration.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Schema/SchemaManagerFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Schema/LegacySchemaManagerFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Driver/Middleware.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Logging/Middleware.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/log/src/LoggerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/ResettableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Logger.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Log/DebugLoggerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/monolog-bridge/Logger.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/Middleware/ConnectionNameAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/Middleware/DebugMiddleware.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/doctrine-bridge/Middleware/Debug/DebugDataHolder.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/Middleware/BacktraceDebugDataHolder.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry-symfony/src/Tracing/Doctrine/DBAL/Compatibility/MiddlewareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry-symfony/src/Tracing/Doctrine/DBAL/TracingDriverMiddleware.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry-symfony/src/Tracing/Doctrine/DBAL/TracingDriverConnectionFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry-symfony/src/Tracing/Doctrine/DBAL/TracingDriverConnectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Tools/DsnParser.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/EntityListenerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/Mapping/EntityListenerServiceResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/Mapping/ContainerEntityListenerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/AuthorizationCheckerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/AuthorizationChecker.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authentication/Token/Storage/TokenStorageInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/service-contracts/ServiceSubscriberInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authentication/Token/Storage/UsageTrackingTokenStorage.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authentication/Token/Storage/TokenStorage.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Security.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-bundle/Security.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/FirewallMapInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-bundle/Security/FirewallMap.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/Logout/LogoutUrlGenerator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/HttpUtils.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/EventListener/IsGrantedAttributeListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/expression-language/ExpressionLanguage.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/AccessDecisionManagerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/TraceableAccessDecisionManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/AccessDecisionManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/Strategy/AccessDecisionStrategyInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/Strategy/AffirmativeStrategy.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/Firewall.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-bundle/EventListener/FirewallListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-bundle/Debug/TraceableFirewallListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/Firewall/FirewallListenerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/Firewall/AbstractListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/Firewall/ContextListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Security/TwoFactor/TwoFactorFirewallConfig.php';
            include_once \dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Security/Http/Utils/RequestDataReader.php';
            include_once \dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Security/TwoFactor/Event/TwoFactorFormListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Security/TwoFactor/Provider/TwoFactorProviderPreparationListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/RememberMe/ResponseListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/HandlerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/Handler.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/AbstractHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/AbstractProcessingHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/StreamHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Processor/ProcessorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Processor/PsrLogMessageProcessor.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/monolog-bridge/Handler/CompatibilityHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/monolog-bridge/Handler/ConsoleHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/monolog-bridge/Handler/CompatibilityProcessingHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authentication/AuthenticationTrustResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Security/Authentication/AuthenticationTrustResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authentication/AuthenticationTrustResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Security/TwoFactor/Provider/TwoFactorProviderRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Security/TwoFactor/Provider/PreparationRecorderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Security/TwoFactor/Provider/TokenPreparationRecorder.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/webpack-encore-bundle/src/Asset/EntrypointLookupCollectionInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/webpack-encore-bundle/src/Asset/EntrypointLookupCollection.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/webpack-encore-bundle/src/EventListener/ResetAssetsEventListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/event-manager/src/EventSubscriber.php';
            include_once \dirname(__DIR__, 4).'/vendor/gedmo/doctrine-extensions/src/Mapping/MappedEventSubscriber.php';
            include_once \dirname(__DIR__, 4).'/vendor/gedmo/doctrine-extensions/src/AbstractTrackingListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/gedmo/doctrine-extensions/src/Blameable/BlameableListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/stof/doctrine-extensions-bundle/src/EventListener/BlameListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/gedmo/doctrine-extensions/src/Loggable/LoggableListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/stof/doctrine-extensions-bundle/src/EventListener/LoggerListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/TranslatorBagInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/Translator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/CacheWarmer/WarmableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/Translation/Translator.php';
            include_once \dirname(__DIR__, 4).'/vendor/lexik/translation-bundle/Translation/Translator.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry/src/State/HubInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry/src/State/HubAdapter.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry/src/ClientInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry/src/Client.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry/src/ClientBuilderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry/src/ClientBuilder.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry/src/Options.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry-symfony/src/Integration/IntegrationConfigurator.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry/src/Integration/IntegrationInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry/src/Integration/IgnoreErrorsIntegration.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry/src/Integration/RequestIntegration.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry/src/Integration/RequestFetcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry-symfony/src/Integration/RequestFetcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry/src/Transport/TransportFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry-symfony/src/Transport/TransportFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/http-factory/src/RequestFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/http-factory/src/ResponseFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/http-factory/src/ServerRequestFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/http-factory/src/StreamFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/http-factory/src/UploadedFileFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/http-factory/src/UriFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/php-http/discovery/src/Psr17Factory.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry/src/Serializer/AbstractSerializer.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry/src/Serializer/SerializerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry/src/Serializer/Serializer.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry/src/Serializer/RepresentationSerializerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry/src/Serializer/RepresentationSerializer.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry-symfony/src/EventListener/KernelEventForwardCompatibilityTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry-symfony/src/EventListener/RequestListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry-symfony/src/EventListener/SubRequestListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry-symfony/src/EventListener/AbstractTracingRequestListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry-symfony/src/EventListener/TracingRequestListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry-symfony/src/EventListener/TracingSubRequestListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry-symfony/src/EventListener/LoginListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/src/Subscriber/SlidingPaginationSubscriber.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/ux-live-component/src/EventListener/LiveComponentSubscriber.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry-symfony/src/Tracing/Cache/TraceableCacheAdapterTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/sentry/sentry-symfony/src/Tracing/Cache/TraceableCacheAdapterForV3.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Traits/AbstractAdapterTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/AbstractAdapter.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/event-dispatcher/src/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher-contracts/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher/Debug/TraceableEventDispatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher/EventDispatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/RequestContextAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Matcher/UrlMatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Generator/UrlGeneratorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/RouterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Matcher/RequestMatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Router.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/Routing/Router.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Debug/TraceableEventDispatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/NullHandler.php';
        };
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    public function getRemovedIds(): array
    {
        return require $this->containerDir.\DIRECTORY_SEPARATOR.'removed-ids.php';
    }

    protected function load($file, $lazyLoad = true): mixed
    {
        if (class_exists($class = __NAMESPACE__.'\\'.$file, false)) {
            return $class::do($this, $lazyLoad);
        }

        if ('.' === $file[-4]) {
            $class = substr($class, 0, -4);
        } else {
            $file .= '.php';
        }

        $service = require $this->containerDir.\DIRECTORY_SEPARATOR.$file;

        return class_exists($class, false) ? $class::do($this, $lazyLoad) : $service;
    }

    protected function createProxy($class, \Closure $factory)
    {
        class_exists($class, false) || require __DIR__.'/'.$class.'.php';

        return $factory();
    }

    /**
     * Gets the public 'cache.security_is_granted_attribute_expression_language' shared service.
     *
     * @return \Sentry\SentryBundle\Tracing\Cache\TraceableCacheAdapter
     */
    protected static function getCache_SecurityIsGrantedAttributeExpressionLanguageService($container)
    {
        return $container->services['cache.security_is_granted_attribute_expression_language'] = new \Sentry\SentryBundle\Tracing\Cache\TraceableCacheAdapter(($container->privates['Sentry\\State\\HubInterface'] ?? self::getHubInterfaceService($container)), \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('K-JDR6WtDI', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container))));
    }

    /**
     * Gets the public 'doctrine' shared service.
     *
     * @return \Doctrine\Bundle\DoctrineBundle\Registry
     */
    protected static function getDoctrineService($container)
    {
        return $container->services['doctrine'] = new \Doctrine\Bundle\DoctrineBundle\Registry($container, $container->parameters['doctrine.connections'], $container->parameters['doctrine.entity_managers'], 'default', 'default');
    }

    /**
     * Gets the public 'doctrine.dbal.default_connection' shared service.
     *
     * @return \Doctrine\DBAL\Connection
     */
    protected static function getDoctrine_Dbal_DefaultConnectionService($container)
    {
        $a = ($container->privates['doctrine.dbal.default_connection.event_manager'] ?? self::getDoctrine_Dbal_DefaultConnection_EventManagerService($container));

        if (isset($container->services['doctrine.dbal.default_connection'])) {
            return $container->services['doctrine.dbal.default_connection'];
        }
        $b = new \Doctrine\DBAL\Configuration();

        $c = new \Symfony\Bridge\Monolog\Logger('doctrine');
        $c->pushHandler(($container->privates['monolog.handler.main'] ?? self::getMonolog_Handler_MainService($container)));
        $d = new \Doctrine\Bundle\DoctrineBundle\Middleware\DebugMiddleware(new \Doctrine\Bundle\DoctrineBundle\Middleware\BacktraceDebugDataHolder([]), ($container->privates['debug.stopwatch'] ??= new \Symfony\Component\Stopwatch\Stopwatch(true)));
        $d->setConnectionName('default');

        $b->setSchemaManagerFactory(new \Doctrine\DBAL\Schema\LegacySchemaManagerFactory());
        $b->setMiddlewares([new \Doctrine\DBAL\Logging\Middleware($c), $d, new \Sentry\SentryBundle\Tracing\Doctrine\DBAL\TracingDriverMiddleware(new \Sentry\SentryBundle\Tracing\Doctrine\DBAL\TracingDriverConnectionFactory(($container->privates['Sentry\\State\\HubInterface'] ?? self::getHubInterfaceService($container))))]);

        return $container->services['doctrine.dbal.default_connection'] = (new \Doctrine\Bundle\DoctrineBundle\ConnectionFactory($container->parameters['doctrine.dbal.connection_factory.types'], new \Doctrine\DBAL\Tools\DsnParser(['db2' => 'ibm_db2', 'mssql' => 'pdo_sqlsrv', 'mysql' => 'pdo_mysql', 'mysql2' => 'pdo_mysql', 'postgres' => 'pdo_pgsql', 'postgresql' => 'pdo_pgsql', 'pgsql' => 'pdo_pgsql', 'sqlite' => 'pdo_sqlite', 'sqlite3' => 'pdo_sqlite'])))->createConnection(['url' => $container->getEnv('DATABASE_URL'), 'driver' => 'pdo_mysql', 'host' => 'localhost', 'port' => NULL, 'user' => 'root', 'password' => NULL, 'driverOptions' => [], 'defaultTableOptions' => []], $b, $a, []);
    }

    /**
     * Gets the public 'doctrine.orm.default_entity_listener_resolver' shared service.
     *
     * @return \Doctrine\Bundle\DoctrineBundle\Mapping\ContainerEntityListenerResolver
     */
    protected static function getDoctrine_Orm_DefaultEntityListenerResolverService($container)
    {
        $container->services['doctrine.orm.default_entity_listener_resolver'] = $instance = new \Doctrine\Bundle\DoctrineBundle\Mapping\ContainerEntityListenerResolver(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'App\\EventListener\\LessonListener' => ['privates', 'App\\EventListener\\LessonListener', 'getLessonListenerService', true],
        ], [
            'App\\EventListener\\LessonListener' => '?',
        ]));

        $instance->registerService('App\\EventListener\\LessonListener', 'App\\EventListener\\LessonListener');
        $instance->registerService('App\\EventListener\\LessonListener', 'App\\EventListener\\LessonListener');

        return $instance;
    }

    /**
     * Gets the public 'doctrine.orm.default_entity_manager' shared service.
     *
     * @return \Doctrine\ORM\EntityManager
     */
    protected static function getDoctrine_Orm_DefaultEntityManagerService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->services['doctrine.orm.default_entity_manager'] = $container->createProxy('EntityManagerGhostD86156e', static fn () => \EntityManagerGhostD86156e::createLazyGhost(static fn ($proxy) => self::getDoctrine_Orm_DefaultEntityManagerService($container, $proxy)));
        }

        include_once \dirname(__DIR__, 4).'/vendor/doctrine/common/src/Proxy/Autoloader.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/lib/Doctrine/ORM/Proxy/Autoloader.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/ObjectManager.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/lib/Doctrine/ORM/EntityManagerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/lib/Doctrine/ORM/EntityManager.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/lib/Doctrine/ORM/Configuration.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/Mapping/Driver/MappingDriver.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/Mapping/MappingDriver.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/Mapping/Driver/MappingDriverChain.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/Driver/CompatibilityAnnotationDriver.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/Mapping/Driver/ColocatedMappingDriver.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/Driver/ReflectionBasedDriver.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/Driver/AttributeDriver.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/Mapping/Driver/FileDriver.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/Driver/XmlDriver.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/Driver/SimplifiedXmlDriver.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/NamingStrategy.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/UnderscoreNamingStrategy.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/QuoteStrategy.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/lib/Doctrine/ORM/Internal/SQLResultCasing.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/lib/Doctrine/ORM/Mapping/DefaultQuoteStrategy.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/lib/Doctrine/ORM/Repository/RepositoryFactory.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/Repository/ContainerRepositoryFactory.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/ManagerConfigurator.php';

        $a = new \Doctrine\ORM\Configuration();

        $b = new \Doctrine\Persistence\Mapping\Driver\MappingDriverChain();

        $c = new \Doctrine\ORM\Mapping\Driver\AttributeDriver([(\dirname(__DIR__, 4).'/src/Entity'), (\dirname(__DIR__, 4).'/vendor/gedmo/doctrine-extensions/src/Loggable/Entity'), (\dirname(__DIR__, 4).'/vendor/gedmo/doctrine-extensions/src/Tree/Entity')], false);
        $d = new \Doctrine\ORM\Mapping\Driver\SimplifiedXmlDriver([(\dirname(__DIR__, 4).'/vendor/gesdinet/jwt-refresh-token-bundle/Resources/config/doctrine') => 'Gesdinet\\JWTRefreshTokenBundle\\Entity', (\dirname(__DIR__, 4).'/vendor/lexik/translation-bundle/Resources/config/doctrine') => 'Lexik\\Bundle\\TranslationBundle\\Entity'], '.orm.xml', false);
        $d->setGlobalBasename('mapping');

        $b->addDriver($c, 'App\\Entity');
        $b->addDriver($c, 'Gedmo\\Loggable\\Entity');
        $b->addDriver($c, 'Gedmo\\Tree\\Entity');
        $b->addDriver($d, 'Gesdinet\\JWTRefreshTokenBundle\\Entity');
        $b->addDriver($d, 'Lexik\\Bundle\\TranslationBundle\\Entity');
        $b->addDriver(new \Doctrine\ORM\Mapping\Driver\SimplifiedXmlDriver([(\dirname(__DIR__, 4).'/vendor/lexik/translation-bundle/Resources/config/model') => 'Lexik\\Bundle\\TranslationBundle\\Model']), 'Lexik\\Bundle\\TranslationBundle\\Model');

        $a->setEntityNamespaces(['App' => 'App\\Entity', 'GedmoLoggable' => 'Gedmo\\Loggable\\Entity', 'GedmoTree' => 'Gedmo\\Tree\\Entity', 'GesdinetJWTRefreshTokenBundle' => 'Gesdinet\\JWTRefreshTokenBundle\\Entity', 'LexikTranslationBundle' => 'Lexik\\Bundle\\TranslationBundle\\Entity']);
        $a->setMetadataCache(new \Symfony\Component\Cache\Adapter\ArrayAdapter());
        $a->setQueryCache(($container->privates['cache.doctrine.orm.default.query.traceable'] ?? self::getCache_Doctrine_Orm_Default_Query_TraceableService($container)));
        $a->setResultCache(($container->privates['cache.doctrine.orm.default.result.traceable'] ?? self::getCache_Doctrine_Orm_Default_Result_TraceableService($container)));
        $a->setMetadataDriverImpl(new \Doctrine\Bundle\DoctrineBundle\Mapping\MappingDriver($b, new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'doctrine.ulid_generator' => ['privates', 'doctrine.ulid_generator', 'getDoctrine_UlidGeneratorService', true],
            'doctrine.uuid_generator' => ['privates', 'doctrine.uuid_generator', 'getDoctrine_UuidGeneratorService', true],
        ], [
            'doctrine.ulid_generator' => '?',
            'doctrine.uuid_generator' => '?',
        ])));
        $a->setProxyDir(($container->targetDir.''.'/doctrine/orm/Proxies'));
        $a->setProxyNamespace('Proxies');
        $a->setAutoGenerateProxyClasses(true);
        $a->setSchemaIgnoreClasses([]);
        $a->setClassMetadataFactoryName('Doctrine\\Bundle\\DoctrineBundle\\Mapping\\ClassMetadataFactory');
        $a->setDefaultRepositoryClassName('Doctrine\\ORM\\EntityRepository');
        $a->setNamingStrategy(new \Doctrine\ORM\Mapping\UnderscoreNamingStrategy(0, true));
        $a->setQuoteStrategy(new \Doctrine\ORM\Mapping\DefaultQuoteStrategy());
        $a->setEntityListenerResolver(($container->services['doctrine.orm.default_entity_listener_resolver'] ?? self::getDoctrine_Orm_DefaultEntityListenerResolverService($container)));
        $a->setLazyGhostObjectEnabled(false);
        $a->setRepositoryFactory(new \Doctrine\Bundle\DoctrineBundle\Repository\ContainerRepositoryFactory(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'App\\Repository\\Common\\AddressRepository' => ['privates', 'App\\Repository\\Common\\AddressRepository', 'getAddressRepositoryService', true],
            'App\\Repository\\Common\\FaqRepository' => ['privates', 'App\\Repository\\Common\\FaqRepository', 'getFaqRepositoryService', true],
            'App\\Repository\\Common\\Layout\\BlockRepository' => ['privates', 'App\\Repository\\Common\\Layout\\BlockRepository', 'getBlockRepositoryService', true],
            'App\\Repository\\Common\\MetaRepository' => ['privates', 'App\\Repository\\Common\\MetaRepository', 'getMetaRepositoryService', true],
            'App\\Repository\\Common\\TagRepository' => ['privates', 'App\\Repository\\Common\\TagRepository', 'getTagRepositoryService', true],
            'App\\Repository\\Common\\TopicRepository' => ['privates', 'App\\Repository\\Common\\TopicRepository', 'getTopicRepositoryService', true],
            'App\\Repository\\Education\\ApplyRepository' => ['privates', 'App\\Repository\\Education\\ApplyRepository', 'getApplyRepositoryService', true],
            'App\\Repository\\Education\\BenefitRepository' => ['privates', 'App\\Repository\\Education\\BenefitRepository', 'getBenefitRepositoryService', true],
            'App\\Repository\\Education\\ExamRepository' => ['privates', 'App\\Repository\\Education\\ExamRepository', 'getExamRepositoryService', true],
            'App\\Repository\\Education\\Lesson\\CategoryRepository' => ['privates', 'App\\Repository\\Education\\Lesson\\CategoryRepository', 'getCategoryRepositoryService', true],
            'App\\Repository\\Education\\Lesson\\LessonRepository' => ['privates', 'App\\Repository\\Education\\Lesson\\LessonRepository', 'getLessonRepositoryService', true],
            'App\\Repository\\Magazine\\Article\\ArticleRepository' => ['privates', 'App\\Repository\\Magazine\\Article\\ArticleRepository', 'getArticleRepositoryService', true],
            'App\\Repository\\System\\Administrator\\AdministratorRepository' => ['privates', 'App\\Repository\\System\\Administrator\\AdministratorRepository', 'getAdministratorRepositoryService', true],
            'App\\Repository\\System\\Administrator\\ResetPasswordRequestRepository' => ['privates', 'App\\Repository\\System\\Administrator\\ResetPasswordRequestRepository', 'getResetPasswordRequestRepositoryService', true],
            'App\\Repository\\System\\File\\UploadGrantRepository' => ['privates', 'App\\Repository\\System\\File\\UploadGrantRepository', 'getUploadGrantRepositoryService', true],
            'App\\Repository\\System\\File\\UploadRepository' => ['privates', 'App\\Repository\\System\\File\\UploadRepository', 'getUploadRepositoryService', true],
            'App\\Repository\\System\\MessageRepository' => ['privates', 'App\\Repository\\System\\MessageRepository', 'getMessageRepositoryService', true],
            'App\\Repository\\System\\Page\\PageRepository' => ['privates', 'App\\Repository\\System\\Page\\PageRepository', 'getPageRepositoryService', true],
            'App\\Repository\\System\\Webspace\\ConfigRepository' => ['privates', 'App\\Repository\\System\\Webspace\\ConfigRepository', 'getConfigRepositoryService', true],
            'App\\Repository\\System\\Webspace\\WebspaceRepository' => ['privates', 'App\\Repository\\System\\Webspace\\WebspaceRepository', 'getWebspaceRepositoryService', true],
            'App\\Repository\\User\\UserRepository' => ['privates', 'App\\Repository\\User\\UserRepository', 'getUserRepositoryService', true],
            'App\\Repository\\User\\UserResetPasswordRequestRepository' => ['privates', 'App\\Repository\\User\\UserResetPasswordRequestRepository', 'getUserResetPasswordRequestRepositoryService', true],
        ], [
            'App\\Repository\\Common\\AddressRepository' => '?',
            'App\\Repository\\Common\\FaqRepository' => '?',
            'App\\Repository\\Common\\Layout\\BlockRepository' => '?',
            'App\\Repository\\Common\\MetaRepository' => '?',
            'App\\Repository\\Common\\TagRepository' => '?',
            'App\\Repository\\Common\\TopicRepository' => '?',
            'App\\Repository\\Education\\ApplyRepository' => '?',
            'App\\Repository\\Education\\BenefitRepository' => '?',
            'App\\Repository\\Education\\ExamRepository' => '?',
            'App\\Repository\\Education\\Lesson\\CategoryRepository' => '?',
            'App\\Repository\\Education\\Lesson\\LessonRepository' => '?',
            'App\\Repository\\Magazine\\Article\\ArticleRepository' => '?',
            'App\\Repository\\System\\Administrator\\AdministratorRepository' => '?',
            'App\\Repository\\System\\Administrator\\ResetPasswordRequestRepository' => '?',
            'App\\Repository\\System\\File\\UploadGrantRepository' => '?',
            'App\\Repository\\System\\File\\UploadRepository' => '?',
            'App\\Repository\\System\\MessageRepository' => '?',
            'App\\Repository\\System\\Page\\PageRepository' => '?',
            'App\\Repository\\System\\Webspace\\ConfigRepository' => '?',
            'App\\Repository\\System\\Webspace\\WebspaceRepository' => '?',
            'App\\Repository\\User\\UserRepository' => '?',
            'App\\Repository\\User\\UserResetPasswordRequestRepository' => '?',
        ])));
        $a->addCustomStringFunction('date_format', 'Oro\\ORM\\Query\\AST\\Functions\\String\\DateFormat');
        $a->addCustomStringFunction('month', 'Oro\\ORM\\Query\\AST\\Functions\\SimpleFunction');
        $a->addCustomNumericFunction('timestampdiff', 'Oro\\ORM\\Query\\AST\\Functions\\Numeric\\TimestampDiff');
        $a->addCustomNumericFunction('dayofyear', 'Oro\\ORM\\Query\\AST\\Functions\\SimpleFunction');
        $a->addCustomNumericFunction('dayofmonth', 'Oro\\ORM\\Query\\AST\\Functions\\SimpleFunction');
        $a->addCustomNumericFunction('dayofweek', 'Oro\\ORM\\Query\\AST\\Functions\\SimpleFunction');
        $a->addCustomNumericFunction('week', 'Oro\\ORM\\Query\\AST\\Functions\\SimpleFunction');
        $a->addCustomNumericFunction('day', 'Oro\\ORM\\Query\\AST\\Functions\\SimpleFunction');
        $a->addCustomNumericFunction('hour', 'Oro\\ORM\\Query\\AST\\Functions\\SimpleFunction');
        $a->addCustomNumericFunction('minute', 'Oro\\ORM\\Query\\AST\\Functions\\SimpleFunction');
        $a->addCustomNumericFunction('month', 'Oro\\ORM\\Query\\AST\\Functions\\SimpleFunction');
        $a->addCustomNumericFunction('quarter', 'Oro\\ORM\\Query\\AST\\Functions\\SimpleFunction');
        $a->addCustomNumericFunction('second', 'Oro\\ORM\\Query\\AST\\Functions\\SimpleFunction');
        $a->addCustomNumericFunction('year', 'Oro\\ORM\\Query\\AST\\Functions\\SimpleFunction');
        $a->addCustomNumericFunction('sign', 'Oro\\ORM\\Query\\AST\\Functions\\Numeric\\Sign');
        $a->addCustomNumericFunction('pow', 'Oro\\ORM\\Query\\AST\\Functions\\Numeric\\Pow');
        $a->addCustomNumericFunction('round', 'Oro\\ORM\\Query\\AST\\Functions\\Numeric\\Round');
        $a->addCustomNumericFunction('ceil', 'Oro\\ORM\\Query\\AST\\Functions\\SimpleFunction');
        $a->addFilter('softdeleteable', 'Gedmo\\SoftDeleteable\\Filter\\SoftDeleteableFilter');

        $instance = ($lazyLoad->__construct(($container->services['doctrine.dbal.default_connection'] ?? self::getDoctrine_Dbal_DefaultConnectionService($container)), $a, ($container->privates['doctrine.dbal.default_connection.event_manager'] ?? self::getDoctrine_Dbal_DefaultConnection_EventManagerService($container))) && false ?: $lazyLoad);

        (new \Doctrine\Bundle\DoctrineBundle\ManagerConfigurator(['softdeleteable'], []))->configure($instance);

        return $instance;
    }

    /**
     * Gets the public 'event_dispatcher' shared service.
     *
     * @return \Symfony\Component\HttpKernel\Debug\TraceableEventDispatcher
     */
    protected static function getEventDispatcherService($container)
    {
        $a = new \Symfony\Bridge\Monolog\Logger('event');
        $a->pushHandler(new \Monolog\Handler\NullHandler());

        $container->services['event_dispatcher'] = $instance = new \Symfony\Component\HttpKernel\Debug\TraceableEventDispatcher(new \Symfony\Component\EventDispatcher\EventDispatcher(), ($container->privates['debug.stopwatch'] ??= new \Symfony\Component\Stopwatch\Stopwatch(true)), $a, ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()));

        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.user_provider', class: 'Symfony\\Component\\Security\\Http\\EventListener\\UserProviderListener')] fn () => ($container->privates['security.listener.user_provider'] ?? $container->load('getSecurity_Listener_UserProviderService')), 'checkPassport'], 1024);
        $instance->addListener('kernel.response', [#[\Closure(name: 'security.context_listener.0', class: 'Symfony\\Component\\Security\\Http\\Firewall\\ContextListener')] fn () => ($container->privates['security.context_listener.0'] ?? self::getSecurity_ContextListener_0Service($container)), 'onKernelResponse'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'webpack_encore.exception_listener', class: 'Symfony\\WebpackEncoreBundle\\EventListener\\ExceptionListener')] fn () => ($container->privates['webpack_encore.exception_listener'] ?? $container->load('getWebpackEncore_ExceptionListenerService')), 'onKernelException'], 0);
        $instance->addListener('lexik_jwt_authentication.on_authentication_success', [#[\Closure(name: 'gesdinet.jwtrefreshtoken.send_token', class: 'Gesdinet\\JWTRefreshTokenBundle\\EventListener\\AttachRefreshTokenOnSuccessListener')] fn () => ($container->privates['gesdinet.jwtrefreshtoken.send_token'] ?? $container->load('getGesdinet_Jwtrefreshtoken_SendTokenService')), 'attachRefreshToken'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [#[\Closure(name: 'Gesdinet\\JWTRefreshTokenBundle\\EventListener\\LogoutEventListener')] fn () => ($container->privates['Gesdinet\\JWTRefreshTokenBundle\\EventListener\\LogoutEventListener'] ?? $container->load('getLogoutEventListenerService')), 'onLogout'], 0);
        $instance->addListener('Lexik\\Bundle\\TranslationBundle\\EventDispatcher\\Event\\GetDatabaseResourcesEvent', [#[\Closure(name: 'Lexik\\Bundle\\TranslationBundle\\EventDispatcher\\Event\\GetDatabaseResourcesEvent', class: 'Lexik\\Bundle\\TranslationBundle\\EventDispatcher\\GetDatabaseResourcesListener')] fn () => ($container->privates['Lexik\\Bundle\\TranslationBundle\\EventDispatcher\\Event\\GetDatabaseResourcesEvent'] ?? $container->load('getGetDatabaseResourcesEventService')), 'onGetDatabaseResources'], 0);
        $instance->addListener('console.command', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\ConsoleListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\ConsoleListener'] ?? $container->load('getConsoleListenerService')), 'handleConsoleCommandEvent'], 128);
        $instance->addListener('console.terminate', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\ConsoleListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\ConsoleListener'] ?? $container->load('getConsoleListenerService')), 'handleConsoleTerminateEvent'], -64);
        $instance->addListener('console.error', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\ConsoleListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\ConsoleListener'] ?? $container->load('getConsoleListenerService')), 'handleConsoleErrorEvent'], -64);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\ErrorListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\ErrorListener'] ?? $container->load('getErrorListenerService')), 'handleExceptionEvent'], 128);
        $instance->addListener('kernel.request', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\RequestListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\RequestListener'] ?? self::getRequestListenerService($container)), 'handleKernelRequestEvent'], 5);
        $instance->addListener('kernel.controller', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\RequestListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\RequestListener'] ?? self::getRequestListenerService($container)), 'handleKernelControllerEvent'], 10);
        $instance->addListener('kernel.request', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\SubRequestListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\SubRequestListener'] ?? self::getSubRequestListenerService($container)), 'handleKernelRequestEvent'], 3);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\SubRequestListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\SubRequestListener'] ?? self::getSubRequestListenerService($container)), 'handleKernelFinishRequestEvent'], 5);
        $instance->addListener('kernel.request', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\TracingRequestListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\TracingRequestListener'] ?? self::getTracingRequestListenerService($container)), 'handleKernelRequestEvent'], 4);
        $instance->addListener('kernel.response', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\TracingRequestListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\TracingRequestListener'] ?? self::getTracingRequestListenerService($container)), 'handleKernelResponseEvent'], 15);
        $instance->addListener('kernel.terminate', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\TracingRequestListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\TracingRequestListener'] ?? self::getTracingRequestListenerService($container)), 'handleKernelTerminateEvent'], 5);
        $instance->addListener('kernel.request', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\TracingSubRequestListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\TracingSubRequestListener'] ?? self::getTracingSubRequestListenerService($container)), 'handleKernelRequestEvent'], 2);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\TracingSubRequestListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\TracingSubRequestListener'] ?? self::getTracingSubRequestListenerService($container)), 'handleKernelFinishRequestEvent'], 10);
        $instance->addListener('kernel.response', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\TracingSubRequestListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\TracingSubRequestListener'] ?? self::getTracingSubRequestListenerService($container)), 'handleKernelResponseEvent'], 15);
        $instance->addListener('console.command', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\TracingConsoleListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\TracingConsoleListener'] ?? $container->load('getTracingConsoleListenerService')), 'handleConsoleCommandEvent'], 118);
        $instance->addListener('console.terminate', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\TracingConsoleListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\TracingConsoleListener'] ?? $container->load('getTracingConsoleListenerService')), 'handleConsoleTerminateEvent'], -54);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageFailedEvent', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\MessengerListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\MessengerListener'] ?? $container->load('getMessengerListenerService')), 'handleWorkerMessageFailedEvent'], 50);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageHandledEvent', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\MessengerListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\MessengerListener'] ?? $container->load('getMessengerListenerService')), 'handleWorkerMessageHandledEvent'], 50);
        $instance->addListener('kernel.request', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\LoginListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\LoginListener'] ?? self::getLoginListenerService($container)), 'handleKernelRequestEvent'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\LoginListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\LoginListener'] ?? self::getLoginListenerService($container)), 'handleLoginSuccessEvent'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'knp_paginator.subscriber.sliding_pagination', class: 'Knp\\Bundle\\PaginatorBundle\\Subscriber\\SlidingPaginationSubscriber')] fn () => ($container->privates['knp_paginator.subscriber.sliding_pagination'] ?? self::getKnpPaginator_Subscriber_SlidingPaginationService($container)), 'onKernelRequest'], 0);
        $instance->addListener('App\\Service\\View\\Event\\ResponseCreatedEvent', [#[\Closure(name: 'app.view.event_subscriber.cookie_setting', class: 'App\\Service\\View\\EventSubscriber\\CookieSettingEventSubscriber')] fn () => ($container->privates['app.view.event_subscriber.cookie_setting'] ??= new \App\Service\View\EventSubscriber\CookieSettingEventSubscriber()), 'handle'], 0);
        $instance->addListener('App\\Service\\View\\Event\\PreCreateResponseEvent', [#[\Closure(name: 'app.view.event_subscriver.exception_response_code_setting', class: 'App\\Service\\View\\EventSubscriber\\ExceptionResponseCodeSettingEventSubscriber')] fn () => ($container->privates['app.view.event_subscriver.exception_response_code_setting'] ??= new \App\Service\View\EventSubscriber\ExceptionResponseCodeSettingEventSubscriber()), 'handle'], 0);
        $instance->addListener('App\\Service\\View\\Event\\PreCreateResponseEvent', [#[\Closure(name: 'app.view.event_subscriber.json_schema_builder', class: 'App\\Service\\View\\EventSubscriber\\JsonSchemaBuilderEventSubscriber')] fn () => ($container->privates['app.view.event_subscriber.json_schema_builder'] ??= new \App\Service\View\EventSubscriber\JsonSchemaBuilderEventSubscriber()), 'handle'], 150);
        $instance->addListener('App\\Service\\View\\Event\\PreCreateResponseEvent', [#[\Closure(name: 'app.view.event_subscriber.pagination_context_adding', class: 'App\\Service\\View\\EventSubscriber\\PaginationContextAddingEventSubscriber')] fn () => ($container->privates['app.view.event_subscriber.pagination_context_adding'] ??= new \App\Service\View\EventSubscriber\PaginationContextAddingEventSubscriber()), 'handle'], 30);
        $instance->addListener('App\\Service\\View\\Event\\PreCreateResponseEvent', [#[\Closure(name: 'app.view.event_subscriber.total_items_adding', class: 'App\\Service\\View\\EventSubscriber\\TotalItemsAddingEventSubscriber')] fn () => ($container->privates['app.view.event_subscriber.total_items_adding'] ??= new \App\Service\View\EventSubscriber\TotalItemsAddingEventSubscriber()), 'handle'], 30);
        $instance->addListener('kernel.controller', [#[\Closure(name: 'App\\EventListener\\LocaleSubscriber')] fn () => ($container->privates['App\\EventListener\\LocaleSubscriber'] ?? self::getLocaleSubscriberService($container)), 'setLocale'], 1);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [#[\Closure(name: 'App\\EventSubscriber\\Authentication\\CookieClearerEventSubscriber')] fn () => ($container->privates['App\\EventSubscriber\\Authentication\\CookieClearerEventSubscriber'] ??= new \App\EventSubscriber\Authentication\CookieClearerEventSubscriber()), 'onLogout'], 0);
        $instance->addListener('lexik_jwt_authentication.on_authentication_success', [#[\Closure(name: 'App\\EventSubscriber\\Authentication\\LoginResponseEventSubscriber')] fn () => ($container->privates['App\\EventSubscriber\\Authentication\\LoginResponseEventSubscriber'] ?? $container->load('getLoginResponseEventSubscriberService')), 'onAuthenticationSuccess'], 0);
        $instance->addListener('gesdinet.refresh_token_failure', [#[\Closure(name: 'App\\EventSubscriber\\Authentication\\LoginResponseEventSubscriber')] fn () => ($container->privates['App\\EventSubscriber\\Authentication\\LoginResponseEventSubscriber'] ?? $container->load('getLoginResponseEventSubscriberService')), 'onAuthenticationFailure'], 0);
        $instance->addListener('App\\Event\\User\\UserDeletedEvent', [#[\Closure(name: 'App\\EventSubscriber\\Portal\\Email\\UserDeletedEmailEventSubscriber')] fn () => ($container->privates['App\\EventSubscriber\\Portal\\Email\\UserDeletedEmailEventSubscriber'] ?? $container->load('getUserDeletedEmailEventSubscriberService')), 'handle'], 0);
        $instance->addListener('App\\Event\\User\\UserPasswordChangedEvent', [#[\Closure(name: 'App\\EventSubscriber\\Portal\\Email\\UserPasswordChangedEmailEventSubscriber')] fn () => ($container->privates['App\\EventSubscriber\\Portal\\Email\\UserPasswordChangedEmailEventSubscriber'] ?? $container->load('getUserPasswordChangedEmailEventSubscriberService')), 'handle'], 0);
        $instance->addListener('App\\Event\\User\\UserPasswordResetEvent', [#[\Closure(name: 'App\\EventSubscriber\\Portal\\Email\\UserPasswordResetEmailEventSubscriber')] fn () => ($container->privates['App\\EventSubscriber\\Portal\\Email\\UserPasswordResetEmailEventSubscriber'] ?? $container->load('getUserPasswordResetEmailEventSubscriberService')), 'handle'], 0);
        $instance->addListener('App\\Event\\User\\UserRegisteredEvent', [#[\Closure(name: 'App\\EventSubscriber\\Portal\\Email\\UserVerificationEmailEventSubscriber')] fn () => ($container->privates['App\\EventSubscriber\\Portal\\Email\\UserVerificationEmailEventSubscriber'] ?? $container->load('getUserVerificationEmailEventSubscriberService')), 'handle'], 0);
        $instance->addListener('App\\Event\\User\\UserVerifiedEvent', [#[\Closure(name: 'App\\EventSubscriber\\Portal\\Email\\UserVerifiedEmailEventSubscriber')] fn () => ($container->privates['App\\EventSubscriber\\Portal\\Email\\UserVerifiedEmailEventSubscriber'] ?? $container->load('getUserVerifiedEmailEventSubscriberService')), 'handle'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'App\\EventSubscriber\\View\\ExceptionEventSubscriber')] fn () => ($container->privates['App\\EventSubscriber\\View\\ExceptionEventSubscriber'] ?? $container->load('getExceptionEventSubscriberService')), 'onException'], -10);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'argument_resolver.request_payload', class: 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestPayloadValueResolver')] fn () => ($container->privates['argument_resolver.request_payload'] ?? self::getArgumentResolver_RequestPayloadService($container)), 'onKernelControllerArguments'], 0);
        $instance->addListener('kernel.response', [#[\Closure(name: 'response_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ResponseListener')] fn () => ($container->privates['response_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\ResponseListener('UTF-8', false)), 'onKernelResponse'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'locale_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleListener')] fn () => ($container->privates['locale_listener'] ?? self::getLocaleListenerService($container)), 'setDefaultLocale'], 100);
        $instance->addListener('kernel.request', [#[\Closure(name: 'locale_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleListener')] fn () => ($container->privates['locale_listener'] ?? self::getLocaleListenerService($container)), 'onKernelRequest'], 16);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'locale_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleListener')] fn () => ($container->privates['locale_listener'] ?? self::getLocaleListenerService($container)), 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'validate_request_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ValidateRequestListener')] fn () => ($container->privates['validate_request_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\ValidateRequestListener()), 'onKernelRequest'], 256);
        $instance->addListener('kernel.response', [#[\Closure(name: 'disallow_search_engine_index_response_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\DisallowRobotsIndexingListener')] fn () => ($container->privates['disallow_search_engine_index_response_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\DisallowRobotsIndexingListener()), 'onResponse'], -255);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'exception_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ErrorListener')] fn () => ($container->privates['exception_listener'] ?? self::getExceptionListenerService($container)), 'onControllerArguments'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'exception_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ErrorListener')] fn () => ($container->privates['exception_listener'] ?? self::getExceptionListenerService($container)), 'logKernelException'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'exception_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ErrorListener')] fn () => ($container->privates['exception_listener'] ?? self::getExceptionListenerService($container)), 'onKernelException'], -128);
        $instance->addListener('kernel.response', [#[\Closure(name: 'exception_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ErrorListener')] fn () => ($container->privates['exception_listener'] ?? self::getExceptionListenerService($container)), 'removeCspHeader'], -128);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'controller.cache_attribute_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\CacheAttributeListener')] fn () => ($container->privates['controller.cache_attribute_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\CacheAttributeListener()), 'onKernelControllerArguments'], 10);
        $instance->addListener('kernel.response', [#[\Closure(name: 'controller.cache_attribute_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\CacheAttributeListener')] fn () => ($container->privates['controller.cache_attribute_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\CacheAttributeListener()), 'onKernelResponse'], -10);
        $instance->addListener('kernel.request', [#[\Closure(name: 'locale_aware_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleAwareListener')] fn () => ($container->privates['locale_aware_listener'] ?? self::getLocaleAwareListenerService($container)), 'onKernelRequest'], 15);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'locale_aware_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleAwareListener')] fn () => ($container->privates['locale_aware_listener'] ?? self::getLocaleAwareListenerService($container)), 'onKernelFinishRequest'], -15);
        $instance->addListener('console.error', [#[\Closure(name: 'console.error_listener', class: 'Symfony\\Component\\Console\\EventListener\\ErrorListener')] fn () => ($container->privates['console.error_listener'] ?? $container->load('getConsole_ErrorListenerService')), 'onConsoleError'], -128);
        $instance->addListener('console.terminate', [#[\Closure(name: 'console.error_listener', class: 'Symfony\\Component\\Console\\EventListener\\ErrorListener')] fn () => ($container->privates['console.error_listener'] ?? $container->load('getConsole_ErrorListenerService')), 'onConsoleTerminate'], -128);
        $instance->addListener('console.error', [#[\Closure(name: 'console.suggest_missing_package_subscriber', class: 'Symfony\\Bundle\\FrameworkBundle\\EventListener\\SuggestMissingPackageSubscriber')] fn () => ($container->privates['console.suggest_missing_package_subscriber'] ??= new \Symfony\Bundle\FrameworkBundle\EventListener\SuggestMissingPackageSubscriber()), 'onConsoleError'], 0);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [#[\Closure(name: 'mailer.envelope_listener', class: 'Symfony\\Component\\Mailer\\EventListener\\EnvelopeListener')] fn () => ($container->privates['mailer.envelope_listener'] ??= new \Symfony\Component\Mailer\EventListener\EnvelopeListener($container->getEnv('MAILER_SENDER_ADDRESS'), [])), 'onMessage'], -255);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [#[\Closure(name: 'mailer.message_listener', class: 'Symfony\\Component\\Mailer\\EventListener\\MessageListener')] fn () => ($container->privates['mailer.message_listener'] ?? $container->load('getMailer_MessageListenerService')), 'onMessage'], 0);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [#[\Closure(name: 'mailer.message_logger_listener', class: 'Symfony\\Component\\Mailer\\EventListener\\MessageLoggerListener')] fn () => ($container->privates['mailer.message_logger_listener'] ??= new \Symfony\Component\Mailer\EventListener\MessageLoggerListener()), 'onMessage'], -255);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [#[\Closure(name: 'mailer.messenger_transport_listener', class: 'Symfony\\Component\\Mailer\\EventListener\\MessengerTransportListener')] fn () => ($container->privates['mailer.messenger_transport_listener'] ??= new \Symfony\Component\Mailer\EventListener\MessengerTransportListener()), 'onMessage'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'debug.debug_handlers_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\DebugHandlersListener')] fn () => ($container->privates['debug.debug_handlers_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\DebugHandlersListener()), 'configure'], 2048);
        $instance->addListener('console.command', [#[\Closure(name: 'debug.debug_handlers_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\DebugHandlersListener')] fn () => ($container->privates['debug.debug_handlers_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\DebugHandlersListener()), 'configure'], 2048);
        $instance->addListener('kernel.request', [#[\Closure(name: 'router_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\RouterListener')] fn () => ($container->privates['router_listener'] ?? self::getRouterListenerService($container)), 'onKernelRequest'], 32);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'router_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\RouterListener')] fn () => ($container->privates['router_listener'] ?? self::getRouterListenerService($container)), 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'router_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\RouterListener')] fn () => ($container->privates['router_listener'] ?? self::getRouterListenerService($container)), 'onKernelException'], -64);
        $instance->addListener('kernel.response', [#[\Closure(name: 'web_link.add_link_header_listener', class: 'Symfony\\Component\\WebLink\\EventListener\\AddLinkHeaderListener')] fn () => ($container->privates['web_link.add_link_header_listener'] ?? self::getWebLink_AddLinkHeaderListenerService($container)), 'onKernelResponse'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'session_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\SessionListener')] fn () => ($container->privates['session_listener'] ?? self::getSessionListenerService($container)), 'onKernelRequest'], 128);
        $instance->addListener('kernel.response', [#[\Closure(name: 'session_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\SessionListener')] fn () => ($container->privates['session_listener'] ?? self::getSessionListenerService($container)), 'onKernelResponse'], -1000);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageFailedEvent', [#[\Closure(name: 'messenger.retry.send_failed_message_for_retry_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\SendFailedMessageForRetryListener')] fn () => ($container->privates['messenger.retry.send_failed_message_for_retry_listener'] ?? $container->load('getMessenger_Retry_SendFailedMessageForRetryListenerService')), 'onMessageFailed'], 100);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageFailedEvent', [#[\Closure(name: 'messenger.failure.add_error_details_stamp_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\AddErrorDetailsStampListener')] fn () => ($container->privates['messenger.failure.add_error_details_stamp_listener'] ??= new \Symfony\Component\Messenger\EventListener\AddErrorDetailsStampListener()), 'onMessageFailed'], 200);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageFailedEvent', [#[\Closure(name: 'messenger.failure.send_failed_message_to_failure_transport_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\SendFailedMessageToFailureTransportListener')] fn () => ($container->privates['messenger.failure.send_failed_message_to_failure_transport_listener'] ?? $container->load('getMessenger_Failure_SendFailedMessageToFailureTransportListenerService')), 'onMessageFailed'], -100);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerRunningEvent', [#[\Closure(name: 'messenger.listener.dispatch_pcntl_signal_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\DispatchPcntlSignalListener')] fn () => ($container->privates['messenger.listener.dispatch_pcntl_signal_listener'] ??= new \Symfony\Component\Messenger\EventListener\DispatchPcntlSignalListener()), 'onWorkerRunning'], 100);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerStartedEvent', [#[\Closure(name: 'messenger.listener.stop_worker_on_restart_signal_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\StopWorkerOnRestartSignalListener')] fn () => ($container->privates['messenger.listener.stop_worker_on_restart_signal_listener'] ?? $container->load('getMessenger_Listener_StopWorkerOnRestartSignalListenerService')), 'onWorkerStarted'], 0);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerRunningEvent', [#[\Closure(name: 'messenger.listener.stop_worker_on_restart_signal_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\StopWorkerOnRestartSignalListener')] fn () => ($container->privates['messenger.listener.stop_worker_on_restart_signal_listener'] ?? $container->load('getMessenger_Listener_StopWorkerOnRestartSignalListenerService')), 'onWorkerRunning'], 0);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerStartedEvent', [#[\Closure(name: 'messenger.listener.stop_worker_signals_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\StopWorkerOnSignalsListener')] fn () => ($container->privates['messenger.listener.stop_worker_signals_listener'] ?? $container->load('getMessenger_Listener_StopWorkerSignalsListenerService')), 'onWorkerStarted'], 100);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageFailedEvent', [#[\Closure(name: 'messenger.listener.stop_worker_on_stop_exception_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\StopWorkerOnCustomStopExceptionListener')] fn () => ($container->privates['messenger.listener.stop_worker_on_stop_exception_listener'] ??= new \Symfony\Component\Messenger\EventListener\StopWorkerOnCustomStopExceptionListener()), 'onMessageFailed'], 0);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerRunningEvent', [#[\Closure(name: 'messenger.listener.stop_worker_on_stop_exception_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\StopWorkerOnCustomStopExceptionListener')] fn () => ($container->privates['messenger.listener.stop_worker_on_stop_exception_listener'] ??= new \Symfony\Component\Messenger\EventListener\StopWorkerOnCustomStopExceptionListener()), 'onWorkerRunning'], 0);
        $instance->addListener('Symfony\\Component\\Notifier\\Event\\MessageEvent', [#[\Closure(name: 'notifier.notification_logger_listener', class: 'Symfony\\Component\\Notifier\\EventListener\\NotificationLoggerListener')] fn () => ($container->privates['notifier.notification_logger_listener'] ??= new \Symfony\Component\Notifier\EventListener\NotificationLoggerListener()), 'onNotification'], -255);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageHandledEvent', [#[\Closure(name: 'doctrine.orm.messenger.event_subscriber.doctrine_clear_entity_manager', class: 'Symfony\\Bridge\\Doctrine\\Messenger\\DoctrineClearEntityManagerWorkerSubscriber')] fn () => ($container->privates['doctrine.orm.messenger.event_subscriber.doctrine_clear_entity_manager'] ?? $container->load('getDoctrine_Orm_Messenger_EventSubscriber_DoctrineClearEntityManagerService')), 'onWorkerMessageHandled'], 0);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageFailedEvent', [#[\Closure(name: 'doctrine.orm.messenger.event_subscriber.doctrine_clear_entity_manager', class: 'Symfony\\Bridge\\Doctrine\\Messenger\\DoctrineClearEntityManagerWorkerSubscriber')] fn () => ($container->privates['doctrine.orm.messenger.event_subscriber.doctrine_clear_entity_manager'] ?? $container->load('getDoctrine_Orm_Messenger_EventSubscriber_DoctrineClearEntityManagerService')), 'onWorkerMessageFailed'], 0);
        $instance->addListener('kernel.view', [#[\Closure(name: 'controller.template_attribute_listener', class: 'Symfony\\Bridge\\Twig\\EventListener\\TemplateAttributeListener')] fn () => ($container->privates['controller.template_attribute_listener'] ?? $container->load('getController_TemplateAttributeListenerService')), 'onKernelView'], -128);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [#[\Closure(name: 'twig.mailer.message_listener', class: 'Symfony\\Component\\Mailer\\EventListener\\MessageListener')] fn () => ($container->privates['twig.mailer.message_listener'] ?? $container->load('getTwig_Mailer_MessageListenerService')), 'onMessage'], 0);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'controller.is_granted_attribute_listener', class: 'Symfony\\Component\\Security\\Http\\EventListener\\IsGrantedAttributeListener')] fn () => ($container->privates['controller.is_granted_attribute_listener'] ?? self::getController_IsGrantedAttributeListenerService($container)), 'onKernelControllerArguments'], 20);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.check_authenticator_credentials', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CheckCredentialsListener')] fn () => ($container->privates['security.listener.check_authenticator_credentials'] ?? $container->load('getSecurity_Listener_CheckAuthenticatorCredentialsService')), 'checkPassport'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'security.listener.password_migrating', class: 'Symfony\\Component\\Security\\Http\\EventListener\\PasswordMigratingListener')] fn () => ($container->privates['security.listener.password_migrating'] ?? $container->load('getSecurity_Listener_PasswordMigratingService')), 'onLoginSuccess'], 0);
        $instance->addListener('debug.security.authorization.vote', [#[\Closure(name: 'debug.security.voter.vote_listener', class: 'Symfony\\Bundle\\SecurityBundle\\EventListener\\VoteListener')] fn () => ($container->privates['debug.security.voter.vote_listener'] ?? $container->load('getDebug_Security_Voter_VoteListenerService')), 'onVoterVote'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'debug.security.firewall', class: 'Symfony\\Bundle\\SecurityBundle\\Debug\\TraceableFirewallListener')] fn () => ($container->privates['debug.security.firewall'] ?? self::getDebug_Security_FirewallService($container)), 'configureLogoutUrlGenerator'], 8);
        $instance->addListener('kernel.request', [#[\Closure(name: 'debug.security.firewall', class: 'Symfony\\Bundle\\SecurityBundle\\Debug\\TraceableFirewallListener')] fn () => ($container->privates['debug.security.firewall'] ?? self::getDebug_Security_FirewallService($container)), 'onKernelRequest'], 8);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'debug.security.firewall', class: 'Symfony\\Bundle\\SecurityBundle\\Debug\\TraceableFirewallListener')] fn () => ($container->privates['debug.security.firewall'] ?? self::getDebug_Security_FirewallService($container)), 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'security.authentication.kernel_exception_listener.two_factor.cms', class: 'Scheb\\TwoFactorBundle\\Security\\Http\\Firewall\\ExceptionListener')] fn () => ($container->privates['security.authentication.kernel_exception_listener.two_factor.cms'] ?? $container->load('getSecurity_Authentication_KernelExceptionListener_TwoFactor_CmsService')), 'onKernelException'], 2);
        $instance->addListener('kernel.request', [#[\Closure(name: 'security.authentication.form_listener.two_factor.cms', class: 'Scheb\\TwoFactorBundle\\Security\\TwoFactor\\Event\\TwoFactorFormListener')] fn () => ($container->privates['security.authentication.form_listener.two_factor.cms'] ?? self::getSecurity_Authentication_FormListener_TwoFactor_CmsService($container)), 'onKernelRequest'], 0);
        $instance->addListener('security.authentication.success', [#[\Closure(name: 'security.authentication.provider_preparation_listener.two_factor.cms', class: 'Scheb\\TwoFactorBundle\\Security\\TwoFactor\\Provider\\TwoFactorProviderPreparationListener')] fn () => ($container->privates['security.authentication.provider_preparation_listener.two_factor.cms'] ?? self::getSecurity_Authentication_ProviderPreparationListener_TwoFactor_CmsService($container)), 'onLogin'], 9223372036854775807);
        $instance->addListener('scheb_two_factor.authentication.require', [#[\Closure(name: 'security.authentication.provider_preparation_listener.two_factor.cms', class: 'Scheb\\TwoFactorBundle\\Security\\TwoFactor\\Provider\\TwoFactorProviderPreparationListener')] fn () => ($container->privates['security.authentication.provider_preparation_listener.two_factor.cms'] ?? self::getSecurity_Authentication_ProviderPreparationListener_TwoFactor_CmsService($container)), 'onAccessDenied'], 0);
        $instance->addListener('scheb_two_factor.authentication.form', [#[\Closure(name: 'security.authentication.provider_preparation_listener.two_factor.cms', class: 'Scheb\\TwoFactorBundle\\Security\\TwoFactor\\Provider\\TwoFactorProviderPreparationListener')] fn () => ($container->privates['security.authentication.provider_preparation_listener.two_factor.cms'] ?? self::getSecurity_Authentication_ProviderPreparationListener_TwoFactor_CmsService($container)), 'onTwoFactorForm'], 0);
        $instance->addListener('kernel.response', [#[\Closure(name: 'security.authentication.provider_preparation_listener.two_factor.cms', class: 'Scheb\\TwoFactorBundle\\Security\\TwoFactor\\Provider\\TwoFactorProviderPreparationListener')] fn () => ($container->privates['security.authentication.provider_preparation_listener.two_factor.cms'] ?? self::getSecurity_Authentication_ProviderPreparationListener_TwoFactor_CmsService($container)), 'onKernelResponse'], 1);
        $instance->addListener('kernel.response', [#[\Closure(name: 'security.rememberme.response_listener', class: 'Symfony\\Component\\Security\\Http\\RememberMe\\ResponseListener')] fn () => ($container->privates['security.rememberme.response_listener'] ??= new \Symfony\Component\Security\Http\RememberMe\ResponseListener()), 'onKernelResponse'], 0);
        $instance->addListener('console.command', [#[\Closure(name: 'monolog.handler.console', class: 'Symfony\\Bridge\\Monolog\\Handler\\ConsoleHandler')] fn () => ($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)), 'onCommand'], 255);
        $instance->addListener('console.terminate', [#[\Closure(name: 'monolog.handler.console', class: 'Symfony\\Bridge\\Monolog\\Handler\\ConsoleHandler')] fn () => ($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)), 'onTerminate'], -255);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'scheb_two_factor.security.listener.check_two_factor_code', class: 'Scheb\\TwoFactorBundle\\Security\\Http\\EventListener\\CheckTwoFactorCodeListener')] fn () => ($container->privates['scheb_two_factor.security.listener.check_two_factor_code'] ?? $container->load('getSchebTwoFactor_Security_Listener_CheckTwoFactorCodeService')), 'checkPassport'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'scheb_two_factor.security.listener.suppress_remember_me', class: 'Scheb\\TwoFactorBundle\\Security\\Http\\EventListener\\SuppressRememberMeListener')] fn () => ($container->privates['scheb_two_factor.security.listener.suppress_remember_me'] ??= new \Scheb\TwoFactorBundle\Security\Http\EventListener\SuppressRememberMeListener()), 'onSuccessfulLogin'], -63);
        $instance->addListener('security.authentication.success', [#[\Closure(name: 'scheb_two_factor.security.authentication_success_event_suppressor', class: 'Scheb\\TwoFactorBundle\\Security\\TwoFactor\\Event\\AuthenticationSuccessEventSuppressor')] fn () => ($container->privates['scheb_two_factor.security.authentication_success_event_suppressor'] ??= new \Scheb\TwoFactorBundle\Security\TwoFactor\Event\AuthenticationSuccessEventSuppressor()), 'onLogin'], 9223372036854775806);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'scheb_two_factor.security.listener.check_backup_code', class: 'Scheb\\TwoFactorBundle\\Security\\Http\\EventListener\\CheckBackupCodeListener')] fn () => ($container->privates['scheb_two_factor.security.listener.check_backup_code'] ?? $container->load('getSchebTwoFactor_Security_Listener_CheckBackupCodeService')), 'checkPassport'], 16);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'Symfony\\WebpackEncoreBundle\\EventListener\\ResetAssetsEventListener')] fn () => ($container->privates['Symfony\\WebpackEncoreBundle\\EventListener\\ResetAssetsEventListener'] ?? self::getResetAssetsEventListenerService($container)), 'resetAssets'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'stof_doctrine_extensions.event_listener.blame', class: 'Stof\\DoctrineExtensionsBundle\\EventListener\\BlameListener')] fn () => ($container->privates['stof_doctrine_extensions.event_listener.blame'] ?? self::getStofDoctrineExtensions_EventListener_BlameService($container)), 'onKernelRequest'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'stof_doctrine_extensions.event_listener.logger', class: 'Stof\\DoctrineExtensionsBundle\\EventListener\\LoggerListener')] fn () => ($container->privates['stof_doctrine_extensions.event_listener.logger'] ?? self::getStofDoctrineExtensions_EventListener_LoggerService($container)), 'onKernelRequest'], 0);
        $instance->addListener('knp_pager.before', [#[\Closure(name: 'knp_paginator.subscriber.paginate', class: 'Knp\\Component\\Pager\\Event\\Subscriber\\Paginate\\PaginationSubscriber')] fn () => ($container->privates['knp_paginator.subscriber.paginate'] ??= new \Knp\Component\Pager\Event\Subscriber\Paginate\PaginationSubscriber()), 'before'], 0);
        $instance->addListener('knp_pager.pagination', [#[\Closure(name: 'knp_paginator.subscriber.paginate', class: 'Knp\\Component\\Pager\\Event\\Subscriber\\Paginate\\PaginationSubscriber')] fn () => ($container->privates['knp_paginator.subscriber.paginate'] ??= new \Knp\Component\Pager\Event\Subscriber\Paginate\PaginationSubscriber()), 'pagination'], 0);
        $instance->addListener('knp_pager.before', [#[\Closure(name: 'knp_paginator.subscriber.sortable', class: 'Knp\\Component\\Pager\\Event\\Subscriber\\Sortable\\SortableSubscriber')] fn () => ($container->privates['knp_paginator.subscriber.sortable'] ??= new \Knp\Component\Pager\Event\Subscriber\Sortable\SortableSubscriber()), 'before'], 1);
        $instance->addListener('knp_pager.before', [#[\Closure(name: 'knp_paginator.subscriber.filtration', class: 'Knp\\Component\\Pager\\Event\\Subscriber\\Filtration\\FiltrationSubscriber')] fn () => ($container->privates['knp_paginator.subscriber.filtration'] ??= new \Knp\Component\Pager\Event\Subscriber\Filtration\FiltrationSubscriber()), 'before'], 1);
        $instance->addListener('knp_pager.pagination', [#[\Closure(name: 'knp_paginator.subscriber.sliding_pagination', class: 'Knp\\Bundle\\PaginatorBundle\\Subscriber\\SlidingPaginationSubscriber')] fn () => ($container->privates['knp_paginator.subscriber.sliding_pagination'] ?? self::getKnpPaginator_Subscriber_SlidingPaginationService($container)), 'pagination'], 1);
        $instance->addListener('Symfony\\UX\\TwigComponent\\Event\\PreMountEvent', [#[\Closure(name: 'ux.live_component.event_listener.data_model_props_subscriber', class: 'Symfony\\UX\\LiveComponent\\EventListener\\DataModelPropsSubscriber')] fn () => ($container->privates['ux.live_component.event_listener.data_model_props_subscriber'] ?? $container->load('getUx_LiveComponent_EventListener_DataModelPropsSubscriberService')), 'onPreMount'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'ux.live_component.event_subscriber', class: 'Symfony\\UX\\LiveComponent\\EventListener\\LiveComponentSubscriber')] fn () => ($container->privates['ux.live_component.event_subscriber'] ?? self::getUx_LiveComponent_EventSubscriberService($container)), 'onKernelRequest'], 0);
        $instance->addListener('kernel.controller', [#[\Closure(name: 'ux.live_component.event_subscriber', class: 'Symfony\\UX\\LiveComponent\\EventListener\\LiveComponentSubscriber')] fn () => ($container->privates['ux.live_component.event_subscriber'] ?? self::getUx_LiveComponent_EventSubscriberService($container)), 'onKernelController'], 10);
        $instance->addListener('kernel.view', [#[\Closure(name: 'ux.live_component.event_subscriber', class: 'Symfony\\UX\\LiveComponent\\EventListener\\LiveComponentSubscriber')] fn () => ($container->privates['ux.live_component.event_subscriber'] ?? self::getUx_LiveComponent_EventSubscriberService($container)), 'onKernelView'], 0);
        $instance->addListener('kernel.response', [#[\Closure(name: 'ux.live_component.event_subscriber', class: 'Symfony\\UX\\LiveComponent\\EventListener\\LiveComponentSubscriber')] fn () => ($container->privates['ux.live_component.event_subscriber'] ?? self::getUx_LiveComponent_EventSubscriberService($container)), 'onKernelResponse'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'ux.live_component.event_subscriber', class: 'Symfony\\UX\\LiveComponent\\EventListener\\LiveComponentSubscriber')] fn () => ($container->privates['ux.live_component.event_subscriber'] ?? self::getUx_LiveComponent_EventSubscriberService($container)), 'onKernelException'], 20);
        $instance->addListener('Symfony\\UX\\TwigComponent\\Event\\PreCreateForRenderEvent', [#[\Closure(name: 'ux.live_component.intercept_child_component_render_subscriber', class: 'Symfony\\UX\\LiveComponent\\EventListener\\InterceptChildComponentRenderSubscriber')] fn () => ($container->privates['ux.live_component.intercept_child_component_render_subscriber'] ?? $container->load('getUx_LiveComponent_InterceptChildComponentRenderSubscriberService')), 'preComponentCreated'], 0);
        $instance->addListener('Symfony\\UX\\TwigComponent\\Event\\PostRenderEvent', [#[\Closure(name: 'ux.live_component.reset_deterministic_id_subscriber', class: 'Symfony\\UX\\LiveComponent\\EventListener\\ResetDeterministicIdSubscriber')] fn () => ($container->privates['ux.live_component.reset_deterministic_id_subscriber'] ?? $container->load('getUx_LiveComponent_ResetDeterministicIdSubscriberService')), 'onPostRender'], 0);
        $instance->addListener('Symfony\\UX\\TwigComponent\\Event\\PreRenderEvent', [#[\Closure(name: 'ux.live_component.add_attributes_subscriber', class: 'Symfony\\UX\\LiveComponent\\EventListener\\AddLiveAttributesSubscriber')] fn () => ($container->privates['ux.live_component.add_attributes_subscriber'] ?? $container->load('getUx_LiveComponent_AddAttributesSubscriberService')), 'onPreRender'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.csrf_protection', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CsrfProtectionListener')] fn () => ($container->privates['security.listener.csrf_protection'] ?? $container->load('getSecurity_Listener_CsrfProtectionService')), 'checkPassport'], 512);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [#[\Closure(name: 'security.logout.listener.csrf_token_clearing', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CsrfTokenClearingLogoutListener')] fn () => ($container->privates['security.logout.listener.csrf_token_clearing'] ?? $container->load('getSecurity_Logout_Listener_CsrfTokenClearingService')), 'onLogout'], 0);

        return $instance;
    }

    /**
     * Gets the public 'http_kernel' shared service.
     *
     * @return \Symfony\Component\HttpKernel\HttpKernel
     */
    protected static function getHttpKernelService($container)
    {
        $a = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['http_kernel'])) {
            return $container->services['http_kernel'];
        }
        $b = ($container->privates['debug.stopwatch'] ??= new \Symfony\Component\Stopwatch\Stopwatch(true));

        return $container->services['http_kernel'] = new \Symfony\Component\HttpKernel\HttpKernel($a, new \Symfony\Component\HttpKernel\Controller\TraceableControllerResolver(new \Symfony\Bundle\FrameworkBundle\Controller\ControllerResolver($container, ($container->privates['monolog.logger.request'] ?? self::getMonolog_Logger_RequestService($container))), $b), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), new \Symfony\Component\HttpKernel\Controller\TraceableArgumentResolver(new \Symfony\Component\HttpKernel\Controller\ArgumentResolver(new \Symfony\Component\HttpKernel\ControllerMetadata\ArgumentMetadataFactory(), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['.debug.value_resolver.security.user_value_resolver'] ?? $container->load('get_Debug_ValueResolver_Security_UserValueResolverService'));
            yield 1 => ($container->privates['.debug.value_resolver.security.security_token_value_resolver'] ?? $container->load('get_Debug_ValueResolver_Security_SecurityTokenValueResolverService'));
            yield 2 => ($container->privates['.debug.value_resolver.doctrine.orm.entity_value_resolver'] ?? $container->load('get_Debug_ValueResolver_Doctrine_Orm_EntityValueResolverService'));
            yield 3 => ($container->privates['.debug.value_resolver.argument_resolver.backed_enum_resolver'] ?? $container->load('get_Debug_ValueResolver_ArgumentResolver_BackedEnumResolverService'));
            yield 4 => ($container->privates['.debug.value_resolver.argument_resolver.uid'] ?? $container->load('get_Debug_ValueResolver_ArgumentResolver_UidService'));
            yield 5 => ($container->privates['.debug.value_resolver.argument_resolver.datetime'] ?? $container->load('get_Debug_ValueResolver_ArgumentResolver_DatetimeService'));
            yield 6 => ($container->privates['.debug.value_resolver.argument_resolver.request_attribute'] ?? $container->load('get_Debug_ValueResolver_ArgumentResolver_RequestAttributeService'));
            yield 7 => ($container->privates['.debug.value_resolver.argument_resolver.request'] ?? $container->load('get_Debug_ValueResolver_ArgumentResolver_RequestService'));
            yield 8 => ($container->privates['.debug.value_resolver.argument_resolver.session'] ?? $container->load('get_Debug_ValueResolver_ArgumentResolver_SessionService'));
            yield 9 => ($container->privates['.debug.value_resolver.app.filter.resolver.filter'] ?? $container->load('get_Debug_ValueResolver_App_Filter_Resolver_FilterService'));
            yield 10 => ($container->privates['.debug.value_resolver.app.pagination.resolver.pagination_context'] ?? $container->load('get_Debug_ValueResolver_App_Pagination_Resolver_PaginationContextService'));
            yield 11 => ($container->privates['.debug.value_resolver.argument_resolver.service'] ?? $container->load('get_Debug_ValueResolver_ArgumentResolver_ServiceService'));
            yield 12 => ($container->privates['.debug.value_resolver.argument_resolver.default'] ?? $container->load('get_Debug_ValueResolver_ArgumentResolver_DefaultService'));
            yield 13 => ($container->privates['.debug.value_resolver.argument_resolver.variadic'] ?? $container->load('get_Debug_ValueResolver_ArgumentResolver_VariadicService'));
            yield 14 => ($container->privates['.debug.value_resolver.argument_resolver.not_tagged_controller'] ?? $container->load('get_Debug_ValueResolver_ArgumentResolver_NotTaggedControllerService'));
        }, 15), new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'Symfony\\Bridge\\Doctrine\\ArgumentResolver\\EntityValueResolver' => ['privates', '.debug.value_resolver.doctrine.orm.entity_value_resolver', 'get_Debug_ValueResolver_Doctrine_Orm_EntityValueResolverService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\BackedEnumValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.backed_enum_resolver', 'get_Debug_ValueResolver_ArgumentResolver_BackedEnumResolverService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DateTimeValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.datetime', 'get_Debug_ValueResolver_ArgumentResolver_DatetimeService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DefaultValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.default', 'get_Debug_ValueResolver_ArgumentResolver_DefaultService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\QueryParameterValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.query_parameter_value_resolver', 'get_Debug_ValueResolver_ArgumentResolver_QueryParameterValueResolverService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestAttributeValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.request_attribute', 'get_Debug_ValueResolver_ArgumentResolver_RequestAttributeService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestPayloadValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.request_payload', 'get_Debug_ValueResolver_ArgumentResolver_RequestPayloadService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.request', 'get_Debug_ValueResolver_ArgumentResolver_RequestService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\ServiceValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.service', 'get_Debug_ValueResolver_ArgumentResolver_ServiceService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\SessionValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.session', 'get_Debug_ValueResolver_ArgumentResolver_SessionService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\UidValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.uid', 'get_Debug_ValueResolver_ArgumentResolver_UidService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\VariadicValueResolver' => ['privates', '.debug.value_resolver.argument_resolver.variadic', 'get_Debug_ValueResolver_ArgumentResolver_VariadicService', true],
            'Symfony\\Component\\Security\\Http\\Controller\\SecurityTokenValueResolver' => ['privates', '.debug.value_resolver.security.security_token_value_resolver', 'get_Debug_ValueResolver_Security_SecurityTokenValueResolverService', true],
            'Symfony\\Component\\Security\\Http\\Controller\\UserValueResolver' => ['privates', '.debug.value_resolver.security.user_value_resolver', 'get_Debug_ValueResolver_Security_UserValueResolverService', true],
            'app.filter.resolver.filter' => ['privates', '.debug.value_resolver.app.filter.resolver.filter', 'get_Debug_ValueResolver_App_Filter_Resolver_FilterService', true],
            'app.pagination.resolver.pagination_context' => ['privates', '.debug.value_resolver.app.pagination.resolver.pagination_context', 'get_Debug_ValueResolver_App_Pagination_Resolver_PaginationContextService', true],
            'argument_resolver.not_tagged_controller' => ['privates', '.debug.value_resolver.argument_resolver.not_tagged_controller', 'get_Debug_ValueResolver_ArgumentResolver_NotTaggedControllerService', true],
        ], [
            'Symfony\\Bridge\\Doctrine\\ArgumentResolver\\EntityValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\BackedEnumValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DateTimeValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DefaultValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\QueryParameterValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestAttributeValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestPayloadValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\ServiceValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\SessionValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\UidValueResolver' => '?',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\VariadicValueResolver' => '?',
            'Symfony\\Component\\Security\\Http\\Controller\\SecurityTokenValueResolver' => '?',
            'Symfony\\Component\\Security\\Http\\Controller\\UserValueResolver' => '?',
            'app.filter.resolver.filter' => '?',
            'app.pagination.resolver.pagination_context' => '?',
            'argument_resolver.not_tagged_controller' => '?',
        ])), $b), false);
    }

    /**
     * Gets the public 'lexik_translation.translator' shared service.
     *
     * @return \Lexik\Bundle\TranslationBundle\Translation\Translator
     */
    protected static function getLexikTranslation_TranslatorService($container)
    {
        $container->services['lexik_translation.translator'] = $instance = new \Lexik\Bundle\TranslationBundle\Translation\Translator(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'Lexik\\Bundle\\TranslationBundle\\Translation\\Loader' => ['privates', 'Lexik\\Bundle\\TranslationBundle\\Translation\\Loader', 'getLoaderService', true],
            'event_dispatcher' => ['services', 'event_dispatcher', 'getEventDispatcherService', false],
            'translation.loader.csv' => ['privates', 'translation.loader.csv', 'getTranslation_Loader_CsvService', true],
            'translation.loader.dat' => ['privates', 'translation.loader.dat', 'getTranslation_Loader_DatService', true],
            'translation.loader.ini' => ['privates', 'translation.loader.ini', 'getTranslation_Loader_IniService', true],
            'translation.loader.json' => ['privates', 'translation.loader.json', 'getTranslation_Loader_JsonService', true],
            'translation.loader.mo' => ['privates', 'translation.loader.mo', 'getTranslation_Loader_MoService', true],
            'translation.loader.php' => ['privates', 'translation.loader.php', 'getTranslation_Loader_PhpService', true],
            'translation.loader.po' => ['privates', 'translation.loader.po', 'getTranslation_Loader_PoService', true],
            'translation.loader.qt' => ['privates', 'translation.loader.qt', 'getTranslation_Loader_QtService', true],
            'translation.loader.res' => ['privates', 'translation.loader.res', 'getTranslation_Loader_ResService', true],
            'translation.loader.xliff' => ['privates', 'translation.loader.xliff', 'getTranslation_Loader_XliffService', true],
            'translation.loader.yml' => ['privates', 'translation.loader.yml', 'getTranslation_Loader_YmlService', true],
        ], [
            'Lexik\\Bundle\\TranslationBundle\\Translation\\Loader' => '?',
            'event_dispatcher' => '?',
            'translation.loader.csv' => '?',
            'translation.loader.dat' => '?',
            'translation.loader.ini' => '?',
            'translation.loader.json' => '?',
            'translation.loader.mo' => '?',
            'translation.loader.php' => '?',
            'translation.loader.po' => '?',
            'translation.loader.qt' => '?',
            'translation.loader.res' => '?',
            'translation.loader.xliff' => '?',
            'translation.loader.yml' => '?',
        ]), ($container->privates['translator.formatter.default'] ?? self::getTranslator_Formatter_DefaultService($container)), 'hu', ['translation.loader.php' => ['php'], 'translation.loader.yml' => ['yaml', 'yml'], 'translation.loader.xliff' => ['xlf', 'xliff'], 'translation.loader.po' => ['po'], 'translation.loader.mo' => ['mo'], 'translation.loader.qt' => ['ts'], 'translation.loader.csv' => ['csv'], 'translation.loader.res' => ['res'], 'translation.loader.dat' => ['dat'], 'translation.loader.ini' => ['ini'], 'translation.loader.json' => ['json'], 'Lexik\\Bundle\\TranslationBundle\\Translation\\Loader' => ['database']], $container->getParameter('lexik_translation.translator.options'));

        $instance->setConfigCacheFactory(($container->privates['config_cache_factory'] ?? self::getConfigCacheFactoryService($container)));
        $instance->setFallbackLocales($container->parameters['enabled_locales']);
        $instance->addDatabaseResources();

        return $instance;
    }

    /**
     * Gets the public 'request_stack' shared service.
     *
     * @return \Symfony\Component\HttpFoundation\RequestStack
     */
    protected static function getRequestStackService($container)
    {
        return $container->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack();
    }

    /**
     * Gets the public 'router' shared service.
     *
     * @return \Symfony\Bundle\FrameworkBundle\Routing\Router
     */
    protected static function getRouterService($container)
    {
        $a = new \Symfony\Bridge\Monolog\Logger('router');
        $a->pushHandler(($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)));
        $a->pushHandler(($container->privates['monolog.handler.main'] ?? self::getMonolog_Handler_MainService($container)));

        $container->services['router'] = $instance = new \Symfony\Bundle\FrameworkBundle\Routing\Router((new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'routing.loader' => ['services', 'routing.loader', 'getRouting_LoaderService', true],
        ], [
            'routing.loader' => 'Symfony\\Component\\Config\\Loader\\LoaderInterface',
        ]))->withContext('router.default', $container), 'kernel::loadRoutes', ['cache_dir' => $container->targetDir.'', 'debug' => true, 'generator_class' => 'Symfony\\Component\\Routing\\Generator\\CompiledUrlGenerator', 'generator_dumper_class' => 'Symfony\\Component\\Routing\\Generator\\Dumper\\CompiledUrlGeneratorDumper', 'matcher_class' => 'Symfony\\Bundle\\FrameworkBundle\\Routing\\RedirectableCompiledUrlMatcher', 'matcher_dumper_class' => 'Symfony\\Component\\Routing\\Matcher\\Dumper\\CompiledUrlMatcherDumper', 'strict_requirements' => NULL, 'resource_type' => 'service'], ($container->privates['router.request_context'] ?? self::getRouter_RequestContextService($container)), ($container->privates['parameter_bag'] ??= new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($container)), $a, 'hu');

        $instance->setConfigCacheFactory(($container->privates['config_cache_factory'] ?? self::getConfigCacheFactoryService($container)));
        $instance->addExpressionLanguageProvider(($container->privates['router.expression_language_provider'] ?? self::getRouter_ExpressionLanguageProviderService($container)));

        return $instance;
    }

    /**
     * Gets the private '.service_locator.a.QUbJ7' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ServiceLocator
     */
    protected static function get_ServiceLocator_A_QUbJ7Service($container)
    {
        return $container->privates['.service_locator.a.QUbJ7'] = new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'security.firewall.map.context.cms' => ['privates', 'security.firewall.map.context.cms', 'getSecurity_Firewall_Map_Context_CmsService', true],
            'security.firewall.map.context.dev' => ['privates', 'security.firewall.map.context.dev', 'getSecurity_Firewall_Map_Context_DevService', true],
        ], [
            'security.firewall.map.context.cms' => '?',
            'security.firewall.map.context.dev' => '?',
        ]);
    }

    /**
     * Gets the private 'App\EventListener\LocaleSubscriber' shared autowired service.
     *
     * @return \App\EventListener\LocaleSubscriber
     */
    protected static function getLocaleSubscriberService($container)
    {
        $a = ($container->privates['security.helper'] ?? self::getSecurity_HelperService($container));

        if (isset($container->privates['App\\EventListener\\LocaleSubscriber'])) {
            return $container->privates['App\\EventListener\\LocaleSubscriber'];
        }
        $b = ($container->privates['translation.locale_switcher'] ?? self::getTranslation_LocaleSwitcherService($container));

        if (isset($container->privates['App\\EventListener\\LocaleSubscriber'])) {
            return $container->privates['App\\EventListener\\LocaleSubscriber'];
        }

        return $container->privates['App\\EventListener\\LocaleSubscriber'] = new \App\EventListener\LocaleSubscriber($a, $b);
    }

    /**
     * Gets the private 'Sentry\SentryBundle\EventListener\LoginListener' shared service.
     *
     * @return \Sentry\SentryBundle\EventListener\LoginListener
     */
    protected static function getLoginListenerService($container)
    {
        return $container->privates['Sentry\\SentryBundle\\EventListener\\LoginListener'] = new \Sentry\SentryBundle\EventListener\LoginListener(($container->privates['Sentry\\State\\HubInterface'] ?? self::getHubInterfaceService($container)), ($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)));
    }

    /**
     * Gets the private 'Sentry\SentryBundle\EventListener\RequestListener' shared service.
     *
     * @return \Sentry\SentryBundle\EventListener\RequestListener
     */
    protected static function getRequestListenerService($container)
    {
        return $container->privates['Sentry\\SentryBundle\\EventListener\\RequestListener'] = new \Sentry\SentryBundle\EventListener\RequestListener(($container->privates['Sentry\\State\\HubInterface'] ?? self::getHubInterfaceService($container)));
    }

    /**
     * Gets the private 'Sentry\SentryBundle\EventListener\SubRequestListener' shared service.
     *
     * @return \Sentry\SentryBundle\EventListener\SubRequestListener
     */
    protected static function getSubRequestListenerService($container)
    {
        return $container->privates['Sentry\\SentryBundle\\EventListener\\SubRequestListener'] = new \Sentry\SentryBundle\EventListener\SubRequestListener(($container->privates['Sentry\\State\\HubInterface'] ?? self::getHubInterfaceService($container)));
    }

    /**
     * Gets the private 'Sentry\SentryBundle\EventListener\TracingRequestListener' shared service.
     *
     * @return \Sentry\SentryBundle\EventListener\TracingRequestListener
     */
    protected static function getTracingRequestListenerService($container)
    {
        return $container->privates['Sentry\\SentryBundle\\EventListener\\TracingRequestListener'] = new \Sentry\SentryBundle\EventListener\TracingRequestListener(($container->privates['Sentry\\State\\HubInterface'] ?? self::getHubInterfaceService($container)));
    }

    /**
     * Gets the private 'Sentry\SentryBundle\EventListener\TracingSubRequestListener' shared service.
     *
     * @return \Sentry\SentryBundle\EventListener\TracingSubRequestListener
     */
    protected static function getTracingSubRequestListenerService($container)
    {
        return $container->privates['Sentry\\SentryBundle\\EventListener\\TracingSubRequestListener'] = new \Sentry\SentryBundle\EventListener\TracingSubRequestListener(($container->privates['Sentry\\State\\HubInterface'] ?? self::getHubInterfaceService($container)));
    }

    /**
     * Gets the private 'Sentry\State\HubInterface' shared service.
     *
     * @return \Sentry\State\HubInterface
     */
    protected static function getHubInterfaceService($container)
    {
        $container->privates['Sentry\\State\\HubInterface'] = $instance = \Sentry\State\HubAdapter::getInstance();

        $a = new \Sentry\Options(['integrations' => new \Sentry\SentryBundle\Integration\IntegrationConfigurator([new \Sentry\Integration\IgnoreErrorsIntegration(['ignore_exceptions' => ['Symfony\\Component\\ErrorHandler\\Error\\FatalError', 'Symfony\\Component\\Debug\\Exception\\FatalErrorException']]), new \Sentry\Integration\RequestIntegration(new \Sentry\SentryBundle\Integration\RequestFetcher(($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), NULL))], true), 'prefixes' => [\dirname(__DIR__, 4), '.', '/opt/cpanel/ea-php82/root/usr/share/pear'], 'environment' => 'prod', 'release' => '1.0.0+no-version-set@{no ref', 'tags' => [], 'in_app_exclude' => [$container->targetDir.'', (\dirname(__DIR__, 4).'/vendor'), $container->targetDir.''], 'in_app_include' => [], 'class_serializers' => [], 'ignore_exceptions' => [], 'ignore_transactions' => []]);

        $b = new \Sentry\ClientBuilder($a);

        $c = new \Http\Discovery\Psr17Factory();

        $b->setSdkIdentifier('sentry.php.symfony');
        $b->setSdkVersion('4.10.0');
        $b->setTransportFactory(new \Sentry\SentryBundle\Transport\TransportFactory($c, $c, $c, $c, NULL, NULL));
        $b->setSerializer(new \Sentry\Serializer\Serializer($a));
        $b->setRepresentationSerializer(new \Sentry\Serializer\RepresentationSerializer($a));
        if ($container->has('Psr\\Log\\NullLogger')) {
            $b->setLogger(($container->services['Psr\\Log\\NullLogger'] ?? $container->get('Psr\\Log\\NullLogger', ContainerInterface::NULL_ON_INVALID_REFERENCE)));
        }

        $instance->bindClient($b->getClient());

        return $instance;
    }

    /**
     * Gets the private 'Symfony\WebpackEncoreBundle\EventListener\ResetAssetsEventListener' shared service.
     *
     * @return \Symfony\WebpackEncoreBundle\EventListener\ResetAssetsEventListener
     */
    protected static function getResetAssetsEventListenerService($container)
    {
        return $container->privates['Symfony\\WebpackEncoreBundle\\EventListener\\ResetAssetsEventListener'] = new \Symfony\WebpackEncoreBundle\EventListener\ResetAssetsEventListener(($container->privates['webpack_encore.entrypoint_lookup_collection'] ?? self::getWebpackEncore_EntrypointLookupCollectionService($container)), ['portal', 'cms']);
    }

    /**
     * Gets the private 'annotations.cache_adapter' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\PhpArrayAdapter
     */
    protected static function getAnnotations_CacheAdapterService($container)
    {
        return \Symfony\Component\Cache\Adapter\PhpArrayAdapter::create(($container->targetDir.''.'/annotations.php'), ($container->privates['cache.annotations.traceable'] ?? self::getCache_Annotations_TraceableService($container)));
    }

    /**
     * Gets the private 'annotations.cached_reader' shared service.
     *
     * @return \Doctrine\Common\Annotations\PsrCachedReader
     */
    protected static function getAnnotations_CachedReaderService($container)
    {
        return $container->privates['annotations.cached_reader'] = new \Doctrine\Common\Annotations\PsrCachedReader(($container->privates['annotations.reader'] ?? self::getAnnotations_ReaderService($container)), self::getAnnotations_CacheAdapterService($container), true);
    }

    /**
     * Gets the private 'annotations.reader' shared service.
     *
     * @return \Doctrine\Common\Annotations\AnnotationReader
     */
    protected static function getAnnotations_ReaderService($container)
    {
        $container->privates['annotations.reader'] = $instance = new \Doctrine\Common\Annotations\AnnotationReader();

        $instance->addGlobalIgnoredName('required');

        return $instance;
    }

    /**
     * Gets the private 'argument_resolver.request_payload' shared service.
     *
     * @return \Symfony\Component\HttpKernel\Controller\ArgumentResolver\RequestPayloadValueResolver
     */
    protected static function getArgumentResolver_RequestPayloadService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->privates['argument_resolver.request_payload'] = $container->createProxy('RequestPayloadValueResolverGhostBcf3cef', static fn () => \RequestPayloadValueResolverGhostBcf3cef::createLazyGhost(static fn ($proxy) => self::getArgumentResolver_RequestPayloadService($container, $proxy)));
        }

        include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ValueResolverInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestPayloadValueResolver.php';

        return ($lazyLoad->__construct(($container->privates['serializer'] ?? self::getSerializerService($container)), ($container->privates['validator'] ?? self::getValidatorService($container)), ($container->services['lexik_translation.translator'] ?? self::getLexikTranslation_TranslatorService($container))) && false ?: $lazyLoad);
    }

    /**
     * Gets the private 'cache.annotations.traceable' shared service.
     *
     * @return \Sentry\SentryBundle\Tracing\Cache\TraceableCacheAdapter
     */
    protected static function getCache_Annotations_TraceableService($container)
    {
        return $container->privates['cache.annotations.traceable'] = new \Sentry\SentryBundle\Tracing\Cache\TraceableCacheAdapter(($container->privates['Sentry\\State\\HubInterface'] ?? self::getHubInterfaceService($container)), \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('3mIuf0jrx1', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container))));
    }

    /**
     * Gets the private 'cache.doctrine.orm.default.query.traceable' shared service.
     *
     * @return \Sentry\SentryBundle\Tracing\Cache\TraceableCacheAdapter
     */
    protected static function getCache_Doctrine_Orm_Default_Query_TraceableService($container)
    {
        return $container->privates['cache.doctrine.orm.default.query.traceable'] = new \Sentry\SentryBundle\Tracing\Cache\TraceableCacheAdapter(($container->privates['Sentry\\State\\HubInterface'] ?? self::getHubInterfaceService($container)), new \Symfony\Component\Cache\Adapter\ArrayAdapter());
    }

    /**
     * Gets the private 'cache.doctrine.orm.default.result.traceable' shared service.
     *
     * @return \Sentry\SentryBundle\Tracing\Cache\TraceableCacheAdapter
     */
    protected static function getCache_Doctrine_Orm_Default_Result_TraceableService($container)
    {
        return $container->privates['cache.doctrine.orm.default.result.traceable'] = new \Sentry\SentryBundle\Tracing\Cache\TraceableCacheAdapter(($container->privates['Sentry\\State\\HubInterface'] ?? self::getHubInterfaceService($container)), new \Symfony\Component\Cache\Adapter\ArrayAdapter());
    }

    /**
     * Gets the private 'config_cache_factory' shared service.
     *
     * @return \Symfony\Component\Config\ResourceCheckerConfigCacheFactory
     */
    protected static function getConfigCacheFactoryService($container)
    {
        return $container->privates['config_cache_factory'] = new \Symfony\Component\Config\ResourceCheckerConfigCacheFactory(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['dependency_injection.config.container_parameters_resource_checker'] ??= new \Symfony\Component\DependencyInjection\Config\ContainerParametersResourceChecker($container));
            yield 1 => ($container->privates['config.resource.self_checking_resource_checker'] ??= new \Symfony\Component\Config\Resource\SelfCheckingResourceChecker());
        }, 2));
    }

    /**
     * Gets the private 'controller.is_granted_attribute_listener' shared service.
     *
     * @return \Symfony\Component\Security\Http\EventListener\IsGrantedAttributeListener
     */
    protected static function getController_IsGrantedAttributeListenerService($container)
    {
        $a = ($container->privates['security.authorization_checker'] ?? self::getSecurity_AuthorizationCheckerService($container));

        if (isset($container->privates['controller.is_granted_attribute_listener'])) {
            return $container->privates['controller.is_granted_attribute_listener'];
        }

        return $container->privates['controller.is_granted_attribute_listener'] = new \Symfony\Component\Security\Http\EventListener\IsGrantedAttributeListener($a, new \Symfony\Component\ExpressionLanguage\ExpressionLanguage(($container->services['cache.security_is_granted_attribute_expression_language'] ?? self::getCache_SecurityIsGrantedAttributeExpressionLanguageService($container))));
    }

    /**
     * Gets the private 'debug.security.access.decision_manager' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authorization\TraceableAccessDecisionManager
     */
    protected static function getDebug_Security_Access_DecisionManagerService($container)
    {
        return $container->privates['debug.security.access.decision_manager'] = new \Symfony\Component\Security\Core\Authorization\TraceableAccessDecisionManager(new \Symfony\Component\Security\Core\Authorization\AccessDecisionManager(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['.debug.security.voter.security.access.authenticated_voter'] ?? $container->load('get_Debug_Security_Voter_Security_Access_AuthenticatedVoterService'));
            yield 1 => ($container->privates['.debug.security.voter.scheb_two_factor.security.access.authenticated_voter'] ?? $container->load('get_Debug_Security_Voter_SchebTwoFactor_Security_Access_AuthenticatedVoterService'));
            yield 2 => ($container->privates['.debug.security.voter.security.access.role_hierarchy_voter'] ?? $container->load('get_Debug_Security_Voter_Security_Access_RoleHierarchyVoterService'));
            yield 3 => ($container->privates['.debug.security.voter.security.access.expression_voter'] ?? $container->load('get_Debug_Security_Voter_Security_Access_ExpressionVoterService'));
        }, 4), new \Symfony\Component\Security\Core\Authorization\Strategy\AffirmativeStrategy(false)));
    }

    /**
     * Gets the private 'debug.security.event_dispatcher.cms' shared service.
     *
     * @return \Symfony\Component\EventDispatcher\Debug\TraceableEventDispatcher
     */
    protected static function getDebug_Security_EventDispatcher_CmsService($container)
    {
        $container->privates['debug.security.event_dispatcher.cms'] = $instance = new \Symfony\Component\EventDispatcher\Debug\TraceableEventDispatcher(new \Symfony\Component\EventDispatcher\EventDispatcher(), ($container->privates['debug.stopwatch'] ??= new \Symfony\Component\Stopwatch\Stopwatch(true)), ($container->privates['monolog.logger'] ?? self::getMonolog_LoggerService($container)), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()));

        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.cms.user_provider', class: 'Symfony\\Component\\Security\\Http\\EventListener\\UserProviderListener')] fn () => ($container->privates['security.listener.cms.user_provider'] ?? $container->load('getSecurity_Listener_Cms_UserProviderService')), 'checkPassport'], 2048);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'security.listener.session.cms', class: 'Symfony\\Component\\Security\\Http\\EventListener\\SessionStrategyListener')] fn () => ($container->privates['security.listener.session.cms'] ?? $container->load('getSecurity_Listener_Session_CmsService')), 'onSuccessfulLogin'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [#[\Closure(name: 'security.logout.listener.default.cms', class: 'Symfony\\Component\\Security\\Http\\EventListener\\DefaultLogoutListener')] fn () => ($container->privates['security.logout.listener.default.cms'] ?? $container->load('getSecurity_Logout_Listener_Default_CmsService')), 'onLogout'], 64);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [#[\Closure(name: 'security.logout.listener.session.cms', class: 'Symfony\\Component\\Security\\Http\\EventListener\\SessionLogoutListener')] fn () => ($container->privates['security.logout.listener.session.cms'] ??= new \Symfony\Component\Security\Http\EventListener\SessionLogoutListener()), 'onLogout'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\AuthenticationTokenCreatedEvent', [#[\Closure(name: 'security.authentication.token_created_listener.two_factor.cms', class: 'Scheb\\TwoFactorBundle\\Security\\TwoFactor\\Event\\AuthenticationTokenListener')] fn () => ($container->privates['security.authentication.token_created_listener.two_factor.cms'] ?? $container->load('getSecurity_Authentication_TokenCreatedListener_TwoFactor_CmsService')), 'onAuthenticationTokenCreated'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'security.listener.check_remember_me_conditions.cms', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CheckRememberMeConditionsListener')] fn () => ($container->privates['security.listener.check_remember_me_conditions.cms'] ?? $container->load('getSecurity_Listener_CheckRememberMeConditions_CmsService')), 'onSuccessfulLogin'], -32);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'security.listener.remember_me.cms', class: 'Symfony\\Component\\Security\\Http\\EventListener\\RememberMeListener')] fn () => ($container->privates['security.listener.remember_me.cms'] ?? $container->load('getSecurity_Listener_RememberMe_CmsService')), 'onSuccessfulLogin'], -64);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginFailureEvent', [#[\Closure(name: 'security.listener.remember_me.cms', class: 'Symfony\\Component\\Security\\Http\\EventListener\\RememberMeListener')] fn () => ($container->privates['security.listener.remember_me.cms'] ?? $container->load('getSecurity_Listener_RememberMe_CmsService')), 'clearCookie'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [#[\Closure(name: 'security.listener.remember_me.cms', class: 'Symfony\\Component\\Security\\Http\\EventListener\\RememberMeListener')] fn () => ($container->privates['security.listener.remember_me.cms'] ?? $container->load('getSecurity_Listener_RememberMe_CmsService')), 'clearCookie'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\TokenDeauthenticatedEvent', [#[\Closure(name: 'security.listener.remember_me.cms', class: 'Symfony\\Component\\Security\\Http\\EventListener\\RememberMeListener')] fn () => ($container->privates['security.listener.remember_me.cms'] ?? $container->load('getSecurity_Listener_RememberMe_CmsService')), 'clearCookie'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.user_checker.cms', class: 'Symfony\\Component\\Security\\Http\\EventListener\\UserCheckerListener')] fn () => ($container->privates['security.listener.user_checker.cms'] ?? $container->load('getSecurity_Listener_UserChecker_CmsService')), 'preCheckCredentials'], 256);
        $instance->addListener('security.authentication.success', [#[\Closure(name: 'security.listener.user_checker.cms', class: 'Symfony\\Component\\Security\\Http\\EventListener\\UserCheckerListener')] fn () => ($container->privates['security.listener.user_checker.cms'] ?? $container->load('getSecurity_Listener_UserChecker_CmsService')), 'postCheckCredentials'], 256);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.user_provider', class: 'Symfony\\Component\\Security\\Http\\EventListener\\UserProviderListener')] fn () => ($container->privates['security.listener.user_provider'] ?? $container->load('getSecurity_Listener_UserProviderService')), 'checkPassport'], 1024);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [#[\Closure(name: 'Gesdinet\\JWTRefreshTokenBundle\\EventListener\\LogoutEventListener')] fn () => ($container->privates['Gesdinet\\JWTRefreshTokenBundle\\EventListener\\LogoutEventListener'] ?? $container->load('getLogoutEventListenerService')), 'onLogout'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'Sentry\\SentryBundle\\EventListener\\LoginListener')] fn () => ($container->privates['Sentry\\SentryBundle\\EventListener\\LoginListener'] ?? self::getLoginListenerService($container)), 'handleLoginSuccessEvent'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [#[\Closure(name: 'App\\EventSubscriber\\Authentication\\CookieClearerEventSubscriber')] fn () => ($container->privates['App\\EventSubscriber\\Authentication\\CookieClearerEventSubscriber'] ??= new \App\EventSubscriber\Authentication\CookieClearerEventSubscriber()), 'onLogout'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.check_authenticator_credentials', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CheckCredentialsListener')] fn () => ($container->privates['security.listener.check_authenticator_credentials'] ?? $container->load('getSecurity_Listener_CheckAuthenticatorCredentialsService')), 'checkPassport'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'security.listener.password_migrating', class: 'Symfony\\Component\\Security\\Http\\EventListener\\PasswordMigratingListener')] fn () => ($container->privates['security.listener.password_migrating'] ?? $container->load('getSecurity_Listener_PasswordMigratingService')), 'onLoginSuccess'], 0);
        $instance->addListener('security.authentication.success', [#[\Closure(name: 'security.authentication.provider_preparation_listener.two_factor.cms', class: 'Scheb\\TwoFactorBundle\\Security\\TwoFactor\\Provider\\TwoFactorProviderPreparationListener')] fn () => ($container->privates['security.authentication.provider_preparation_listener.two_factor.cms'] ?? self::getSecurity_Authentication_ProviderPreparationListener_TwoFactor_CmsService($container)), 'onLogin'], 9223372036854775807);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'scheb_two_factor.security.listener.check_two_factor_code', class: 'Scheb\\TwoFactorBundle\\Security\\Http\\EventListener\\CheckTwoFactorCodeListener')] fn () => ($container->privates['scheb_two_factor.security.listener.check_two_factor_code'] ?? $container->load('getSchebTwoFactor_Security_Listener_CheckTwoFactorCodeService')), 'checkPassport'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'scheb_two_factor.security.listener.suppress_remember_me', class: 'Scheb\\TwoFactorBundle\\Security\\Http\\EventListener\\SuppressRememberMeListener')] fn () => ($container->privates['scheb_two_factor.security.listener.suppress_remember_me'] ??= new \Scheb\TwoFactorBundle\Security\Http\EventListener\SuppressRememberMeListener()), 'onSuccessfulLogin'], -63);
        $instance->addListener('security.authentication.success', [#[\Closure(name: 'scheb_two_factor.security.authentication_success_event_suppressor', class: 'Scheb\\TwoFactorBundle\\Security\\TwoFactor\\Event\\AuthenticationSuccessEventSuppressor')] fn () => ($container->privates['scheb_two_factor.security.authentication_success_event_suppressor'] ??= new \Scheb\TwoFactorBundle\Security\TwoFactor\Event\AuthenticationSuccessEventSuppressor()), 'onLogin'], 9223372036854775806);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'scheb_two_factor.security.listener.check_backup_code', class: 'Scheb\\TwoFactorBundle\\Security\\Http\\EventListener\\CheckBackupCodeListener')] fn () => ($container->privates['scheb_two_factor.security.listener.check_backup_code'] ?? $container->load('getSchebTwoFactor_Security_Listener_CheckBackupCodeService')), 'checkPassport'], 16);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.csrf_protection', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CsrfProtectionListener')] fn () => ($container->privates['security.listener.csrf_protection'] ?? $container->load('getSecurity_Listener_CsrfProtectionService')), 'checkPassport'], 512);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [#[\Closure(name: 'security.logout.listener.csrf_token_clearing', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CsrfTokenClearingLogoutListener')] fn () => ($container->privates['security.logout.listener.csrf_token_clearing'] ?? $container->load('getSecurity_Logout_Listener_CsrfTokenClearingService')), 'onLogout'], 0);

        return $instance;
    }

    /**
     * Gets the private 'debug.security.firewall' shared service.
     *
     * @return \Symfony\Bundle\SecurityBundle\Debug\TraceableFirewallListener
     */
    protected static function getDebug_Security_FirewallService($container)
    {
        $a = ($container->privates['security.firewall.map'] ?? self::getSecurity_Firewall_MapService($container));

        if (isset($container->privates['debug.security.firewall'])) {
            return $container->privates['debug.security.firewall'];
        }
        $b = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->privates['debug.security.firewall'])) {
            return $container->privates['debug.security.firewall'];
        }

        return $container->privates['debug.security.firewall'] = new \Symfony\Bundle\SecurityBundle\Debug\TraceableFirewallListener($a, $b, ($container->privates['security.logout_url_generator'] ?? self::getSecurity_LogoutUrlGeneratorService($container)));
    }

    /**
     * Gets the private 'doctrine.dbal.default_connection.event_manager' shared service.
     *
     * @return \Symfony\Bridge\Doctrine\ContainerAwareEventManager
     */
    protected static function getDoctrine_Dbal_DefaultConnection_EventManagerService($container)
    {
        return $container->privates['doctrine.dbal.default_connection.event_manager'] = new \Symfony\Bridge\Doctrine\ContainerAwareEventManager(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'App\\EventSubscriber\\System\\AddressableEventSubscriber' => ['privates', 'App\\EventSubscriber\\System\\AddressableEventSubscriber', 'getAddressableEventSubscriberService', true],
            'App\\EventSubscriber\\System\\BlockableEventSubscriber' => ['privates', 'App\\EventSubscriber\\System\\BlockableEventSubscriber', 'getBlockableEventSubscriberService', true],
            'App\\EventSubscriber\\System\\MetableEventSubscriber' => ['privates', 'App\\EventSubscriber\\System\\MetableEventSubscriber', 'getMetableEventSubscriberService', true],
            'App\\EventSubscriber\\System\\NestedableEventSubscriber' => ['privates', 'App\\EventSubscriber\\System\\NestedableEventSubscriber', 'getNestedableEventSubscriberService', true],
            'App\\EventSubscriber\\System\\TagableEventSubscriber' => ['privates', 'App\\EventSubscriber\\System\\TagableEventSubscriber', 'getTagableEventSubscriberService', true],
            'App\\EventSubscriber\\System\\TranslatableEventSubscriber' => ['privates', 'App\\EventSubscriber\\System\\TranslatableEventSubscriber', 'getTranslatableEventSubscriberService', true],
            'doctrine.orm.default_listeners.attach_entity_listeners' => ['privates', 'doctrine.orm.default_listeners.attach_entity_listeners', 'getDoctrine_Orm_DefaultListeners_AttachEntityListenersService', true],
            'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_listener' => ['privates', 'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_listener', 'getDoctrine_Orm_Listeners_DoctrineDbalCacheAdapterSchemaListenerService', true],
            'doctrine.orm.listeners.doctrine_token_provider_schema_listener' => ['privates', 'doctrine.orm.listeners.doctrine_token_provider_schema_listener', 'getDoctrine_Orm_Listeners_DoctrineTokenProviderSchemaListenerService', true],
            'doctrine.orm.listeners.lock_store_schema_listener' => ['privates', 'doctrine.orm.listeners.lock_store_schema_listener', 'getDoctrine_Orm_Listeners_LockStoreSchemaListenerService', true],
            'doctrine.orm.listeners.pdo_session_handler_schema_listener' => ['privates', 'doctrine.orm.listeners.pdo_session_handler_schema_listener', 'getDoctrine_Orm_Listeners_PdoSessionHandlerSchemaListenerService', true],
            'doctrine.orm.messenger.doctrine_schema_listener' => ['privates', 'doctrine.orm.messenger.doctrine_schema_listener', 'getDoctrine_Orm_Messenger_DoctrineSchemaListenerService', true],
            'lexik_translation.orm.listener' => ['privates', 'lexik_translation.orm.listener', 'getLexikTranslation_Orm_ListenerService', true],
            'stof_doctrine_extensions.listener.blameable' => ['privates', 'stof_doctrine_extensions.listener.blameable', 'getStofDoctrineExtensions_Listener_BlameableService', false],
            'stof_doctrine_extensions.listener.loggable' => ['privates', 'stof_doctrine_extensions.listener.loggable', 'getStofDoctrineExtensions_Listener_LoggableService', false],
            'stof_doctrine_extensions.listener.sluggable' => ['privates', 'stof_doctrine_extensions.listener.sluggable', 'getStofDoctrineExtensions_Listener_SluggableService', true],
            'stof_doctrine_extensions.listener.softdeleteable' => ['privates', 'stof_doctrine_extensions.listener.softdeleteable', 'getStofDoctrineExtensions_Listener_SoftdeleteableService', true],
            'stof_doctrine_extensions.listener.timestampable' => ['privates', 'stof_doctrine_extensions.listener.timestampable', 'getStofDoctrineExtensions_Listener_TimestampableService', true],
            'stof_doctrine_extensions.listener.tree' => ['privates', 'stof_doctrine_extensions.listener.tree', 'getStofDoctrineExtensions_Listener_TreeService', true],
            'turbo.doctrine.event_listener' => ['privates', 'turbo.doctrine.event_listener', 'getTurbo_Doctrine_EventListenerService', true],
        ], [
            'App\\EventSubscriber\\System\\AddressableEventSubscriber' => '?',
            'App\\EventSubscriber\\System\\BlockableEventSubscriber' => '?',
            'App\\EventSubscriber\\System\\MetableEventSubscriber' => '?',
            'App\\EventSubscriber\\System\\NestedableEventSubscriber' => '?',
            'App\\EventSubscriber\\System\\TagableEventSubscriber' => '?',
            'App\\EventSubscriber\\System\\TranslatableEventSubscriber' => '?',
            'doctrine.orm.default_listeners.attach_entity_listeners' => '?',
            'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_listener' => '?',
            'doctrine.orm.listeners.doctrine_token_provider_schema_listener' => '?',
            'doctrine.orm.listeners.lock_store_schema_listener' => '?',
            'doctrine.orm.listeners.pdo_session_handler_schema_listener' => '?',
            'doctrine.orm.messenger.doctrine_schema_listener' => '?',
            'lexik_translation.orm.listener' => '?',
            'stof_doctrine_extensions.listener.blameable' => '?',
            'stof_doctrine_extensions.listener.loggable' => '?',
            'stof_doctrine_extensions.listener.sluggable' => '?',
            'stof_doctrine_extensions.listener.softdeleteable' => '?',
            'stof_doctrine_extensions.listener.timestampable' => '?',
            'stof_doctrine_extensions.listener.tree' => '?',
            'turbo.doctrine.event_listener' => '?',
        ]), [[['loadClassMetadata'], 'stof_doctrine_extensions.listener.loggable'], [['onFlush'], 'stof_doctrine_extensions.listener.loggable'], [['postPersist'], 'stof_doctrine_extensions.listener.loggable'], 'App\\EventSubscriber\\System\\AddressableEventSubscriber', 'App\\EventSubscriber\\System\\BlockableEventSubscriber', 'App\\EventSubscriber\\System\\MetableEventSubscriber', 'App\\EventSubscriber\\System\\NestedableEventSubscriber', 'App\\EventSubscriber\\System\\TagableEventSubscriber', 'App\\EventSubscriber\\System\\TranslatableEventSubscriber', [['postGenerateSchema'], 'doctrine.orm.messenger.doctrine_schema_listener'], [['onSchemaCreateTable'], 'doctrine.orm.messenger.doctrine_schema_listener'], [['postGenerateSchema'], 'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_listener'], [['postGenerateSchema'], 'doctrine.orm.listeners.doctrine_token_provider_schema_listener'], [['postGenerateSchema'], 'doctrine.orm.listeners.pdo_session_handler_schema_listener'], [['postGenerateSchema'], 'doctrine.orm.listeners.lock_store_schema_listener'], [['loadClassMetadata'], 'doctrine.orm.default_listeners.attach_entity_listeners'], [['prePersist'], 'stof_doctrine_extensions.listener.timestampable'], [['onFlush'], 'stof_doctrine_extensions.listener.timestampable'], [['loadClassMetadata'], 'stof_doctrine_extensions.listener.timestampable'], [['prePersist'], 'stof_doctrine_extensions.listener.blameable'], [['onFlush'], 'stof_doctrine_extensions.listener.blameable'], [['loadClassMetadata'], 'stof_doctrine_extensions.listener.blameable'], [['loadClassMetadata'], 'stof_doctrine_extensions.listener.softdeleteable'], [['onFlush'], 'stof_doctrine_extensions.listener.softdeleteable'], [['prePersist'], 'stof_doctrine_extensions.listener.tree'], [['preRemove'], 'stof_doctrine_extensions.listener.tree'], [['preUpdate'], 'stof_doctrine_extensions.listener.tree'], [['onFlush'], 'stof_doctrine_extensions.listener.tree'], [['loadClassMetadata'], 'stof_doctrine_extensions.listener.tree'], [['postPersist'], 'stof_doctrine_extensions.listener.tree'], [['postUpdate'], 'stof_doctrine_extensions.listener.tree'], [['postRemove'], 'stof_doctrine_extensions.listener.tree'], [['prePersist'], 'stof_doctrine_extensions.listener.sluggable'], [['onFlush'], 'stof_doctrine_extensions.listener.sluggable'], [['loadClassMetadata'], 'stof_doctrine_extensions.listener.sluggable'], [['loadClassMetadata'], 'lexik_translation.orm.listener'], [['onFlush'], 'turbo.doctrine.event_listener'], [['postFlush'], 'turbo.doctrine.event_listener']]);
    }

    /**
     * Gets the private 'exception_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\ErrorListener
     */
    protected static function getExceptionListenerService($container)
    {
        return $container->privates['exception_listener'] = new \Symfony\Component\HttpKernel\EventListener\ErrorListener('error_controller', ($container->privates['monolog.logger.request'] ?? self::getMonolog_Logger_RequestService($container)), true, []);
    }

    /**
     * Gets the private 'knp_paginator.subscriber.sliding_pagination' shared service.
     *
     * @return \Knp\Bundle\PaginatorBundle\Subscriber\SlidingPaginationSubscriber
     */
    protected static function getKnpPaginator_Subscriber_SlidingPaginationService($container)
    {
        return $container->privates['knp_paginator.subscriber.sliding_pagination'] = new \Knp\Bundle\PaginatorBundle\Subscriber\SlidingPaginationSubscriber(['defaultPaginationTemplate' => '@KnpPaginator/Pagination/bootstrap_v5_pagination.html.twig', 'defaultSortableTemplate' => '@KnpPaginator/Pagination/sortable_link.html.twig', 'defaultFiltrationTemplate' => '@KnpPaginator/Pagination/filtration.html.twig', 'defaultPageRange' => 5, 'defaultPageLimit' => NULL]);
    }

    /**
     * Gets the private 'locale_aware_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\LocaleAwareListener
     */
    protected static function getLocaleAwareListenerService($container)
    {
        return $container->privates['locale_aware_listener'] = new \Symfony\Component\HttpKernel\EventListener\LocaleAwareListener(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['slugger'] ??= new \Symfony\Component\String\Slugger\AsciiSlugger('hu'));
            yield 1 => ($container->privates['translator.default'] ?? $container->load('getTranslator_DefaultService'));
            yield 2 => ($container->privates['translation.locale_switcher'] ?? self::getTranslation_LocaleSwitcherService($container));
            yield 3 => ($container->services['lexik_translation.translator'] ?? self::getLexikTranslation_TranslatorService($container));
        }, 4), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()));
    }

    /**
     * Gets the private 'locale_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\LocaleListener
     */
    protected static function getLocaleListenerService($container)
    {
        return $container->privates['locale_listener'] = new \Symfony\Component\HttpKernel\EventListener\LocaleListener(($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), 'hu', ($container->services['router'] ?? self::getRouterService($container)), false, $container->parameters['kernel.enabled_locales']);
    }

    /**
     * Gets the private 'mime_types' shared service.
     *
     * @return \Symfony\Component\Mime\MimeTypes
     */
    protected static function getMimeTypesService($container)
    {
        $container->privates['mime_types'] = $instance = new \Symfony\Component\Mime\MimeTypes();

        $instance->setDefault($instance);

        return $instance;
    }

    /**
     * Gets the private 'monolog.handler.console' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Handler\ConsoleHandler
     */
    protected static function getMonolog_Handler_ConsoleService($container)
    {
        return $container->privates['monolog.handler.console'] = new \Symfony\Bridge\Monolog\Handler\ConsoleHandler(NULL, true, [], []);
    }

    /**
     * Gets the private 'monolog.handler.main' shared service.
     *
     * @return \Monolog\Handler\StreamHandler
     */
    protected static function getMonolog_Handler_MainService($container)
    {
        $container->privates['monolog.handler.main'] = $instance = new \Monolog\Handler\StreamHandler((\dirname(__DIR__, 3).'/log/prod.log'), 100, true, NULL, false);

        $instance->pushProcessor(new \Monolog\Processor\PsrLogMessageProcessor());

        return $instance;
    }

    /**
     * Gets the private 'monolog.logger' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Logger
     */
    protected static function getMonolog_LoggerService($container)
    {
        $container->privates['monolog.logger'] = $instance = new \Symfony\Bridge\Monolog\Logger('app');

        $instance->useMicrosecondTimestamps(true);
        $instance->pushHandler(($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)));
        $instance->pushHandler(($container->privates['monolog.handler.main'] ?? self::getMonolog_Handler_MainService($container)));

        return $instance;
    }

    /**
     * Gets the private 'monolog.logger.cache' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Logger
     */
    protected static function getMonolog_Logger_CacheService($container)
    {
        $container->privates['monolog.logger.cache'] = $instance = new \Symfony\Bridge\Monolog\Logger('cache');

        $instance->pushHandler(($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)));
        $instance->pushHandler(($container->privates['monolog.handler.main'] ?? self::getMonolog_Handler_MainService($container)));

        return $instance;
    }

    /**
     * Gets the private 'monolog.logger.request' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Logger
     */
    protected static function getMonolog_Logger_RequestService($container)
    {
        $container->privates['monolog.logger.request'] = $instance = new \Symfony\Bridge\Monolog\Logger('request');

        $instance->pushHandler(($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)));
        $instance->pushHandler(($container->privates['monolog.handler.main'] ?? self::getMonolog_Handler_MainService($container)));

        return $instance;
    }

    /**
     * Gets the private 'monolog.logger.security' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Logger
     */
    protected static function getMonolog_Logger_SecurityService($container)
    {
        $container->privates['monolog.logger.security'] = $instance = new \Symfony\Bridge\Monolog\Logger('security');

        $instance->pushHandler(($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)));
        $instance->pushHandler(($container->privates['monolog.handler.main'] ?? self::getMonolog_Handler_MainService($container)));

        return $instance;
    }

    /**
     * Gets the private 'parameter_bag' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag
     */
    protected static function getParameterBagService($container)
    {
        return $container->privates['parameter_bag'] = new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($container);
    }

    /**
     * Gets the private 'property_accessor' shared service.
     *
     * @return \Symfony\Component\PropertyAccess\PropertyAccessor
     */
    protected static function getPropertyAccessorService($container)
    {
        $a = ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());

        return $container->privates['property_accessor'] = new \Symfony\Component\PropertyAccess\PropertyAccessor(3, 2, new \Symfony\Component\Cache\Adapter\ArrayAdapter(0, false), $a, $a);
    }

    /**
     * Gets the private 'property_info' shared service.
     *
     * @return \Symfony\Component\PropertyInfo\PropertyInfoExtractor
     */
    protected static function getPropertyInfoService($container)
    {
        return $container->privates['property_info'] = new \Symfony\Component\PropertyInfo\PropertyInfoExtractor(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['property_info.serializer_extractor'] ?? $container->load('getPropertyInfo_SerializerExtractorService'));
            yield 1 => ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());
            yield 2 => ($container->privates['doctrine.orm.default_entity_manager.property_info_extractor'] ?? $container->load('getDoctrine_Orm_DefaultEntityManager_PropertyInfoExtractorService'));
        }, 3), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['doctrine.orm.default_entity_manager.property_info_extractor'] ?? $container->load('getDoctrine_Orm_DefaultEntityManager_PropertyInfoExtractorService'));
            yield 1 => ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());
        }, 2), new RewindableGenerator(fn () => new \EmptyIterator(), 0), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['doctrine.orm.default_entity_manager.property_info_extractor'] ?? $container->load('getDoctrine_Orm_DefaultEntityManager_PropertyInfoExtractorService'));
            yield 1 => ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());
        }, 2), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());
        }, 1));
    }

    /**
     * Gets the private 'router.expression_language_provider' shared service.
     *
     * @return \Symfony\Component\Routing\Matcher\ExpressionLanguageProvider
     */
    protected static function getRouter_ExpressionLanguageProviderService($container)
    {
        return $container->privates['router.expression_language_provider'] = new \Symfony\Component\Routing\Matcher\ExpressionLanguageProvider(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'env' => ['privates', 'container.getenv', 'getContainer_GetenvService', true],
            'service' => ['services', 'container.get_routing_condition_service', 'getContainer_GetRoutingConditionServiceService', true],
        ], [
            'env' => 'Closure',
            'service' => 'Closure',
        ]));
    }

    /**
     * Gets the private 'router.request_context' shared service.
     *
     * @return \Symfony\Component\Routing\RequestContext
     */
    protected static function getRouter_RequestContextService($container)
    {
        $container->privates['router.request_context'] = $instance = \Symfony\Component\Routing\RequestContext::fromUri('', 'localhost', 'http', 80, 443);

        $instance->setParameter('_functions', ($container->privates['router.expression_language_provider'] ?? self::getRouter_ExpressionLanguageProviderService($container)));

        return $instance;
    }

    /**
     * Gets the private 'router_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\RouterListener
     */
    protected static function getRouterListenerService($container)
    {
        return $container->privates['router_listener'] = new \Symfony\Component\HttpKernel\EventListener\RouterListener(($container->services['router'] ?? self::getRouterService($container)), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), ($container->privates['router.request_context'] ?? self::getRouter_RequestContextService($container)), ($container->privates['monolog.logger.request'] ?? self::getMonolog_Logger_RequestService($container)), \dirname(__DIR__, 4), true);
    }

    /**
     * Gets the private 'scheb_two_factor.provider_preparation_recorder' shared service.
     *
     * @return \Scheb\TwoFactorBundle\Security\TwoFactor\Provider\TokenPreparationRecorder
     */
    protected static function getSchebTwoFactor_ProviderPreparationRecorderService($container)
    {
        return $container->privates['scheb_two_factor.provider_preparation_recorder'] = new \Scheb\TwoFactorBundle\Security\TwoFactor\Provider\TokenPreparationRecorder(($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)));
    }

    /**
     * Gets the private 'scheb_two_factor.provider_registry' shared service.
     *
     * @return \Scheb\TwoFactorBundle\Security\TwoFactor\Provider\TwoFactorProviderRegistry
     */
    protected static function getSchebTwoFactor_ProviderRegistryService($container)
    {
        return $container->privates['scheb_two_factor.provider_registry'] = new \Scheb\TwoFactorBundle\Security\TwoFactor\Provider\TwoFactorProviderRegistry(new RewindableGenerator(function () use ($container) {
            yield 'email' => ($container->privates['scheb_two_factor.security.email.provider'] ?? $container->load('getSchebTwoFactor_Security_Email_ProviderService'));
            yield 'google' => ($container->privates['scheb_two_factor.security.google.provider'] ?? $container->load('getSchebTwoFactor_Security_Google_ProviderService'));
        }, 2));
    }

    /**
     * Gets the private 'scheb_two_factor.security.authentication.trust_resolver' shared service.
     *
     * @return \Scheb\TwoFactorBundle\Security\Authentication\AuthenticationTrustResolver
     */
    protected static function getSchebTwoFactor_Security_Authentication_TrustResolverService($container)
    {
        return $container->privates['scheb_two_factor.security.authentication.trust_resolver'] = new \Scheb\TwoFactorBundle\Security\Authentication\AuthenticationTrustResolver(new \Symfony\Component\Security\Core\Authentication\AuthenticationTrustResolver());
    }

    /**
     * Gets the private 'security.authentication.form_listener.two_factor.cms' shared service.
     *
     * @return \Scheb\TwoFactorBundle\Security\TwoFactor\Event\TwoFactorFormListener
     */
    protected static function getSecurity_Authentication_FormListener_TwoFactor_CmsService($container)
    {
        $a = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->privates['security.authentication.form_listener.two_factor.cms'])) {
            return $container->privates['security.authentication.form_listener.two_factor.cms'];
        }

        return $container->privates['security.authentication.form_listener.two_factor.cms'] = new \Scheb\TwoFactorBundle\Security\TwoFactor\Event\TwoFactorFormListener(($container->privates['security.firewall_config.two_factor.cms'] ?? self::getSecurity_FirewallConfig_TwoFactor_CmsService($container)), ($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)), $a);
    }

    /**
     * Gets the private 'security.authentication.provider_preparation_listener.two_factor.cms' shared service.
     *
     * @return \Scheb\TwoFactorBundle\Security\TwoFactor\Provider\TwoFactorProviderPreparationListener
     */
    protected static function getSecurity_Authentication_ProviderPreparationListener_TwoFactor_CmsService($container)
    {
        $a = ($container->privates['scheb_two_factor.provider_registry'] ?? self::getSchebTwoFactor_ProviderRegistryService($container));

        if (isset($container->privates['security.authentication.provider_preparation_listener.two_factor.cms'])) {
            return $container->privates['security.authentication.provider_preparation_listener.two_factor.cms'];
        }

        return $container->privates['security.authentication.provider_preparation_listener.two_factor.cms'] = new \Scheb\TwoFactorBundle\Security\TwoFactor\Provider\TwoFactorProviderPreparationListener($a, ($container->privates['scheb_two_factor.provider_preparation_recorder'] ?? self::getSchebTwoFactor_ProviderPreparationRecorderService($container)), ($container->privates['monolog.logger'] ?? self::getMonolog_LoggerService($container)), 'cms', false, false);
    }

    /**
     * Gets the private 'security.authorization_checker' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authorization\AuthorizationChecker
     */
    protected static function getSecurity_AuthorizationCheckerService($container)
    {
        $a = ($container->privates['debug.security.access.decision_manager'] ?? self::getDebug_Security_Access_DecisionManagerService($container));

        if (isset($container->privates['security.authorization_checker'])) {
            return $container->privates['security.authorization_checker'];
        }

        return $container->privates['security.authorization_checker'] = new \Symfony\Component\Security\Core\Authorization\AuthorizationChecker(($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)), $a, false, false);
    }

    /**
     * Gets the private 'security.context_listener.0' shared service.
     *
     * @return \Symfony\Component\Security\Http\Firewall\ContextListener
     */
    protected static function getSecurity_ContextListener_0Service($container)
    {
        $a = ($container->privates['debug.security.event_dispatcher.cms'] ?? self::getDebug_Security_EventDispatcher_CmsService($container));

        if (isset($container->privates['security.context_listener.0'])) {
            return $container->privates['security.context_listener.0'];
        }

        return $container->privates['security.context_listener.0'] = new \Symfony\Component\Security\Http\Firewall\ContextListener(($container->privates['security.untracked_token_storage'] ??= new \Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorage()), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['security.user.provider.concrete.admin_provider'] ?? $container->load('getSecurity_User_Provider_Concrete_AdminProviderService'));
        }, 1), 'cms', ($container->privates['monolog.logger.security'] ?? self::getMonolog_Logger_SecurityService($container)), $a, ($container->privates['scheb_two_factor.security.authentication.trust_resolver'] ?? self::getSchebTwoFactor_Security_Authentication_TrustResolverService($container)), [($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)), 'enableUsageTracking']);
    }

    /**
     * Gets the private 'security.firewall.map' shared service.
     *
     * @return \Symfony\Bundle\SecurityBundle\Security\FirewallMap
     */
    protected static function getSecurity_Firewall_MapService($container)
    {
        $a = ($container->privates['.service_locator.a.QUbJ7'] ?? self::get_ServiceLocator_A_QUbJ7Service($container));

        if (isset($container->privates['security.firewall.map'])) {
            return $container->privates['security.firewall.map'];
        }

        return $container->privates['security.firewall.map'] = new \Symfony\Bundle\SecurityBundle\Security\FirewallMap($a, new RewindableGenerator(function () use ($container) {
            yield 'security.firewall.map.context.dev' => ($container->privates['.security.request_matcher.kLbKLHa'] ?? $container->load('get_Security_RequestMatcher_KLbKLHaService'));
            yield 'security.firewall.map.context.cms' => ($container->privates['.security.request_matcher.OR07RHo'] ?? $container->load('get_Security_RequestMatcher_OR07RHoService'));
        }, 2));
    }

    /**
     * Gets the private 'security.firewall_config.two_factor.cms' shared service.
     *
     * @return \Scheb\TwoFactorBundle\Security\TwoFactor\TwoFactorFirewallConfig
     */
    protected static function getSecurity_FirewallConfig_TwoFactor_CmsService($container)
    {
        return $container->privates['security.firewall_config.two_factor.cms'] = new \Scheb\TwoFactorBundle\Security\TwoFactor\TwoFactorFirewallConfig(['provider' => 'admin_provider', 'auth_form_path' => 'cms_2fa_login', 'check_path' => 'cms_2fa_login_check', 'post_only' => true, 'always_use_default_target_path' => false, 'default_target_path' => '/', 'success_handler' => NULL, 'failure_handler' => NULL, 'authentication_required_handler' => NULL, 'auth_code_parameter_name' => '_auth_code', 'trusted_parameter_name' => '_trusted', 'remember_me_sets_trusted' => false, 'multi_factor' => false, 'prepare_on_login' => false, 'prepare_on_access_denied' => false, 'enable_csrf' => false, 'csrf_parameter' => '_csrf_token', 'csrf_token_id' => 'two_factor'], 'cms', ($container->privates['security.http_utils'] ?? self::getSecurity_HttpUtilsService($container)), new \Scheb\TwoFactorBundle\Security\Http\Utils\RequestDataReader());
    }

    /**
     * Gets the private 'security.helper' shared service.
     *
     * @return \Symfony\Bundle\SecurityBundle\Security
     */
    protected static function getSecurity_HelperService($container)
    {
        return $container->privates['security.helper'] = new \Symfony\Bundle\SecurityBundle\Security(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'request_stack' => ['services', 'request_stack', 'getRequestStackService', false],
            'security.authenticator.managers_locator' => ['privates', 'security.authenticator.managers_locator', 'getSecurity_Authenticator_ManagersLocatorService', true],
            'security.authorization_checker' => ['privates', 'security.authorization_checker', 'getSecurity_AuthorizationCheckerService', false],
            'security.csrf.token_manager' => ['privates', 'security.csrf.token_manager', 'getSecurity_Csrf_TokenManagerService', true],
            'security.firewall.event_dispatcher_locator' => ['privates', 'security.firewall.event_dispatcher_locator', 'getSecurity_Firewall_EventDispatcherLocatorService', true],
            'security.firewall.map' => ['privates', 'security.firewall.map', 'getSecurity_Firewall_MapService', false],
            'security.token_storage' => ['privates', 'security.token_storage', 'getSecurity_TokenStorageService', false],
            'security.user_checker' => ['privates', 'security.user_checker', 'getSecurity_UserCheckerService', true],
        ], [
            'request_stack' => '?',
            'security.authenticator.managers_locator' => '?',
            'security.authorization_checker' => '?',
            'security.csrf.token_manager' => '?',
            'security.firewall.event_dispatcher_locator' => '?',
            'security.firewall.map' => '?',
            'security.token_storage' => '?',
            'security.user_checker' => '?',
        ]), ['dev' => NULL, 'cms' => new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'security.authenticator.form_login.cms' => ['privates', 'security.authenticator.form_login.cms', 'getSecurity_Authenticator_FormLogin_CmsService', true],
            'security.authenticator.remember_me.cms' => ['privates', 'security.authenticator.remember_me.cms', 'getSecurity_Authenticator_RememberMe_CmsService', true],
            'security.authenticator.two_factor.cms' => ['privates', 'security.authenticator.two_factor.cms', 'getSecurity_Authenticator_TwoFactor_CmsService', true],
        ], [
            'security.authenticator.form_login.cms' => '?',
            'security.authenticator.remember_me.cms' => '?',
            'security.authenticator.two_factor.cms' => '?',
        ])]);
    }

    /**
     * Gets the private 'security.http_utils' shared service.
     *
     * @return \Symfony\Component\Security\Http\HttpUtils
     */
    protected static function getSecurity_HttpUtilsService($container)
    {
        $a = ($container->services['router'] ?? self::getRouterService($container));

        return $container->privates['security.http_utils'] = new \Symfony\Component\Security\Http\HttpUtils($a, $a, '{^https?://%s$}i', '{^https://%s$}i');
    }

    /**
     * Gets the private 'security.logout_url_generator' shared service.
     *
     * @return \Symfony\Component\Security\Http\Logout\LogoutUrlGenerator
     */
    protected static function getSecurity_LogoutUrlGeneratorService($container)
    {
        $container->privates['security.logout_url_generator'] = $instance = new \Symfony\Component\Security\Http\Logout\LogoutUrlGenerator(($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), ($container->services['router'] ?? self::getRouterService($container)), ($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)));

        $instance->registerListener('cms', 'cms_logout', 'logout', '_csrf_token', NULL, NULL);

        return $instance;
    }

    /**
     * Gets the private 'security.token_storage' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authentication\Token\Storage\UsageTrackingTokenStorage
     */
    protected static function getSecurity_TokenStorageService($container)
    {
        return $container->privates['security.token_storage'] = new \Symfony\Component\Security\Core\Authentication\Token\Storage\UsageTrackingTokenStorage(($container->privates['security.untracked_token_storage'] ??= new \Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorage()), new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'request_stack' => ['services', 'request_stack', 'getRequestStackService', false],
        ], [
            'request_stack' => '?',
        ]));
    }

    /**
     * Gets the private 'serializer' shared service.
     *
     * @return \Symfony\Component\Serializer\Serializer
     */
    protected static function getSerializerService($container)
    {
        $a = ($container->services['lexik_translation.translator'] ?? self::getLexikTranslation_TranslatorService($container));

        if (isset($container->privates['serializer'])) {
            return $container->privates['serializer'];
        }
        $b = ($container->privates['property_info'] ?? self::getPropertyInfoService($container));

        if (isset($container->privates['serializer'])) {
            return $container->privates['serializer'];
        }
        $c = ($container->privates['property_accessor'] ?? self::getPropertyAccessorService($container));
        $d = ($container->privates['serializer.mapping.class_metadata_factory'] ?? self::getSerializer_Mapping_ClassMetadataFactoryService($container));

        $e = new \Symfony\Component\Serializer\NameConverter\MetadataAwareNameConverter($d);
        $f = new \Symfony\Component\Serializer\Mapping\ClassDiscriminatorFromClassMetadata($d);

        return $container->privates['serializer'] = new \Symfony\Component\Serializer\Serializer([new \Symfony\Component\Serializer\Normalizer\UnwrappingDenormalizer($c), new \App\Service\View\Serializer\Exception\PartialDenormalizationExceptionNormalizerDecorator(new \App\Service\View\Serializer\Exception\HttpExceptionNormalizerDecorator(new \App\Service\View\Serializer\Exception\ConstraintViolationExceptionNormalizerDecorator(new \App\Service\View\Serializer\Exception\AnonymizingExceptionNormalizerDecorator(new \App\Service\View\Serializer\Exception\ExceptionNormalizer(), false))), $a), new \Symfony\Component\Messenger\Transport\Serialization\Normalizer\FlattenExceptionNormalizer(), new \Symfony\Component\Serializer\Normalizer\ProblemNormalizer(true, translator: $a), new \Symfony\Component\Serializer\Normalizer\UidNormalizer(), new \Symfony\Component\Serializer\Normalizer\DateTimeNormalizer(), new \Symfony\Component\Serializer\Normalizer\ConstraintViolationListNormalizer([], $e), new \Symfony\Component\Serializer\Normalizer\MimeMessageNormalizer(new \Symfony\Component\Serializer\Normalizer\PropertyNormalizer($d, $e, $b, $f, NULL)), new \Symfony\Component\Serializer\Normalizer\DateTimeZoneNormalizer(), new \Symfony\Component\Serializer\Normalizer\DateIntervalNormalizer(), new \Symfony\Component\Serializer\Normalizer\FormErrorNormalizer(), new \Symfony\Component\Serializer\Normalizer\BackedEnumNormalizer(), new \Symfony\Component\Serializer\Normalizer\DataUriNormalizer(($container->privates['mime_types'] ?? self::getMimeTypesService($container))), new \Symfony\Component\Serializer\Normalizer\JsonSerializableNormalizer(NULL, NULL), new \Symfony\Component\Serializer\Normalizer\ArrayDenormalizer(), new \Symfony\Component\Serializer\Normalizer\ObjectNormalizer($d, $e, $c, $b, $f, NULL)], [new \Symfony\Component\Serializer\Encoder\XmlEncoder(), new \Symfony\Component\Serializer\Encoder\JsonEncoder(NULL, NULL), new \Symfony\Component\Serializer\Encoder\YamlEncoder(NULL, NULL), new \Symfony\Component\Serializer\Encoder\CsvEncoder()]);
    }

    /**
     * Gets the private 'serializer.mapping.class_metadata_factory' shared service.
     *
     * @return \Symfony\Component\Serializer\Mapping\Factory\ClassMetadataFactory
     */
    protected static function getSerializer_Mapping_ClassMetadataFactoryService($container)
    {
        return $container->privates['serializer.mapping.class_metadata_factory'] = new \Symfony\Component\Serializer\Mapping\Factory\ClassMetadataFactory(new \Symfony\Component\Serializer\Mapping\Loader\LoaderChain([new \Symfony\Component\Serializer\Mapping\Loader\AnnotationLoader(($container->privates['annotations.cached_reader'] ?? self::getAnnotations_CachedReaderService($container)))]));
    }

    /**
     * Gets the private 'session_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\SessionListener
     */
    protected static function getSessionListenerService($container)
    {
        return $container->privates['session_listener'] = new \Symfony\Component\HttpKernel\EventListener\SessionListener(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'logger' => ['privates', 'monolog.logger', 'getMonolog_LoggerService', false],
            'session_factory' => ['privates', 'session.factory', 'getSession_FactoryService', true],
        ], [
            'logger' => '?',
            'session_factory' => '?',
        ]), true, $container->parameters['session.storage.options']);
    }

    /**
     * Gets the private 'stof_doctrine_extensions.event_listener.blame' shared service.
     *
     * @return \Stof\DoctrineExtensionsBundle\EventListener\BlameListener
     */
    protected static function getStofDoctrineExtensions_EventListener_BlameService($container)
    {
        $a = ($container->privates['security.authorization_checker'] ?? self::getSecurity_AuthorizationCheckerService($container));

        if (isset($container->privates['stof_doctrine_extensions.event_listener.blame'])) {
            return $container->privates['stof_doctrine_extensions.event_listener.blame'];
        }

        return $container->privates['stof_doctrine_extensions.event_listener.blame'] = new \Stof\DoctrineExtensionsBundle\EventListener\BlameListener(($container->privates['stof_doctrine_extensions.listener.blameable'] ?? self::getStofDoctrineExtensions_Listener_BlameableService($container)), ($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)), $a);
    }

    /**
     * Gets the private 'stof_doctrine_extensions.event_listener.logger' shared service.
     *
     * @return \Stof\DoctrineExtensionsBundle\EventListener\LoggerListener
     */
    protected static function getStofDoctrineExtensions_EventListener_LoggerService($container)
    {
        $a = ($container->privates['security.authorization_checker'] ?? self::getSecurity_AuthorizationCheckerService($container));

        if (isset($container->privates['stof_doctrine_extensions.event_listener.logger'])) {
            return $container->privates['stof_doctrine_extensions.event_listener.logger'];
        }

        return $container->privates['stof_doctrine_extensions.event_listener.logger'] = new \Stof\DoctrineExtensionsBundle\EventListener\LoggerListener(($container->privates['stof_doctrine_extensions.listener.loggable'] ?? self::getStofDoctrineExtensions_Listener_LoggableService($container)), ($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)), $a);
    }

    /**
     * Gets the private 'stof_doctrine_extensions.listener.blameable' shared service.
     *
     * @return \Gedmo\Blameable\BlameableListener
     */
    protected static function getStofDoctrineExtensions_Listener_BlameableService($container)
    {
        $container->privates['stof_doctrine_extensions.listener.blameable'] = $instance = new \Gedmo\Blameable\BlameableListener();

        $instance->setCacheItemPool(($container->privates['stof_doctrine_extensions.metadata_cache'] ??= new \Symfony\Component\Cache\Adapter\ArrayAdapter()));
        $instance->setAnnotationReader(($container->privates['annotations.cached_reader'] ?? self::getAnnotations_CachedReaderService($container)));

        return $instance;
    }

    /**
     * Gets the private 'stof_doctrine_extensions.listener.loggable' shared service.
     *
     * @return \Gedmo\Loggable\LoggableListener
     */
    protected static function getStofDoctrineExtensions_Listener_LoggableService($container)
    {
        $container->privates['stof_doctrine_extensions.listener.loggable'] = $instance = new \Gedmo\Loggable\LoggableListener();

        $instance->setCacheItemPool(($container->privates['stof_doctrine_extensions.metadata_cache'] ??= new \Symfony\Component\Cache\Adapter\ArrayAdapter()));
        $instance->setAnnotationReader(($container->privates['annotations.cached_reader'] ?? self::getAnnotations_CachedReaderService($container)));

        return $instance;
    }

    /**
     * Gets the private 'translation.locale_switcher' shared service.
     *
     * @return \Symfony\Component\Translation\LocaleSwitcher
     */
    protected static function getTranslation_LocaleSwitcherService($container)
    {
        return $container->privates['translation.locale_switcher'] = new \Symfony\Component\Translation\LocaleSwitcher('hu', new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['slugger'] ??= new \Symfony\Component\String\Slugger\AsciiSlugger('hu'));
            yield 1 => ($container->privates['translator.default'] ?? $container->load('getTranslator_DefaultService'));
            yield 2 => ($container->services['lexik_translation.translator'] ?? self::getLexikTranslation_TranslatorService($container));
        }, 3), ($container->privates['router.request_context'] ?? self::getRouter_RequestContextService($container)));
    }

    /**
     * Gets the private 'translator.formatter.default' shared service.
     *
     * @return \Symfony\Component\Translation\Formatter\MessageFormatter
     */
    protected static function getTranslator_Formatter_DefaultService($container)
    {
        return $container->privates['translator.formatter.default'] = new \Symfony\Component\Translation\Formatter\MessageFormatter(new \Symfony\Component\Translation\IdentityTranslator());
    }

    /**
     * Gets the private 'ux.live_component.event_subscriber' shared service.
     *
     * @return \Symfony\UX\LiveComponent\EventListener\LiveComponentSubscriber
     */
    protected static function getUx_LiveComponent_EventSubscriberService($container)
    {
        return $container->privates['ux.live_component.event_subscriber'] = new \Symfony\UX\LiveComponent\EventListener\LiveComponentSubscriber((new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'Symfony\\Component\\Security\\Csrf\\CsrfTokenManagerInterface' => ['privates', 'security.csrf.token_manager', 'getSecurity_Csrf_TokenManagerService', true],
            'Symfony\\UX\\LiveComponent\\LiveComponentHydrator' => ['privates', 'ux.live_component.component_hydrator', 'getUx_LiveComponent_ComponentHydratorService', true],
            'Symfony\\UX\\LiveComponent\\Metadata\\LiveComponentMetadataFactory' => ['privates', 'ux.live_component.metadata_factory', 'getUx_LiveComponent_MetadataFactoryService', true],
            'Symfony\\UX\\TwigComponent\\ComponentFactory' => ['privates', 'ux.twig_component.component_factory', 'getUx_TwigComponent_ComponentFactoryService', true],
            'Symfony\\UX\\TwigComponent\\ComponentRenderer' => ['privates', 'ux.twig_component.component_renderer', 'getUx_TwigComponent_ComponentRendererService', true],
        ], [
            'Symfony\\Component\\Security\\Csrf\\CsrfTokenManagerInterface' => '?',
            'Symfony\\UX\\LiveComponent\\LiveComponentHydrator' => 'Symfony\\UX\\LiveComponent\\LiveComponentHydrator',
            'Symfony\\UX\\LiveComponent\\Metadata\\LiveComponentMetadataFactory' => 'Symfony\\UX\\LiveComponent\\Metadata\\LiveComponentMetadataFactory',
            'Symfony\\UX\\TwigComponent\\ComponentFactory' => 'Symfony\\UX\\TwigComponent\\ComponentFactory',
            'Symfony\\UX\\TwigComponent\\ComponentRenderer' => 'Symfony\\UX\\TwigComponent\\ComponentRenderer',
        ]))->withContext('ux.live_component.event_subscriber', $container));
    }

    /**
     * Gets the private 'validator' shared service.
     *
     * @return \Symfony\Component\Validator\Validator\ValidatorInterface
     */
    protected static function getValidatorService($container)
    {
        $a = ($container->privates['validator.builder'] ?? self::getValidator_BuilderService($container));

        if (isset($container->privates['validator'])) {
            return $container->privates['validator'];
        }

        return $container->privates['validator'] = $a->getValidator();
    }

    /**
     * Gets the private 'validator.builder' shared service.
     *
     * @return \Symfony\Component\Validator\ValidatorBuilder
     */
    protected static function getValidator_BuilderService($container)
    {
        $container->privates['validator.builder'] = $instance = \Symfony\Component\Validator\Validation::createValidatorBuilder();

        $a = ($container->privates['property_info'] ?? self::getPropertyInfoService($container));

        $instance->setConstraintValidatorFactory(new \Symfony\Component\Validator\ContainerConstraintValidatorFactory(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'App\\Validator\\Constraints\\EmailNotRegisteredValidator' => ['privates', 'App\\Validator\\Constraints\\EmailNotRegisteredValidator', 'getEmailNotRegisteredValidatorService', true],
            'App\\Validator\\Constraints\\RecaptchaValidator' => ['privates', 'App\\Validator\\Constraints\\RecaptchaValidator', 'getRecaptchaValidatorService', true],
            'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator' => ['privates', 'doctrine.orm.validator.unique', 'getDoctrine_Orm_Validator_UniqueService', true],
            'Symfony\\Component\\Security\\Core\\Validator\\Constraints\\UserPasswordValidator' => ['privates', 'security.validator.user_password', 'getSecurity_Validator_UserPasswordService', true],
            'Symfony\\Component\\Validator\\Constraints\\EmailValidator' => ['privates', 'validator.email', 'getValidator_EmailService', true],
            'Symfony\\Component\\Validator\\Constraints\\ExpressionValidator' => ['privates', 'validator.expression', 'getValidator_ExpressionService', true],
            'Symfony\\Component\\Validator\\Constraints\\NoSuspiciousCharactersValidator' => ['privates', 'validator.no_suspicious_characters', 'getValidator_NoSuspiciousCharactersService', true],
            'Symfony\\Component\\Validator\\Constraints\\NotCompromisedPasswordValidator' => ['privates', 'validator.not_compromised_password', 'getValidator_NotCompromisedPasswordService', true],
            'Symfony\\Component\\Validator\\Constraints\\WhenValidator' => ['privates', 'validator.when', 'getValidator_WhenService', true],
            'doctrine.orm.validator.unique' => ['privates', 'doctrine.orm.validator.unique', 'getDoctrine_Orm_Validator_UniqueService', true],
            'security.validator.user_password' => ['privates', 'security.validator.user_password', 'getSecurity_Validator_UserPasswordService', true],
            'validator.expression' => ['privates', 'validator.expression', 'getValidator_ExpressionService', true],
        ], [
            'App\\Validator\\Constraints\\EmailNotRegisteredValidator' => '?',
            'App\\Validator\\Constraints\\RecaptchaValidator' => '?',
            'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator' => '?',
            'Symfony\\Component\\Security\\Core\\Validator\\Constraints\\UserPasswordValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\EmailValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\ExpressionValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\NoSuspiciousCharactersValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\NotCompromisedPasswordValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\WhenValidator' => '?',
            'doctrine.orm.validator.unique' => '?',
            'security.validator.user_password' => '?',
            'validator.expression' => '?',
        ])));
        if ($container->has('lexik_translation.translator')) {
            $instance->setTranslator(($container->services['lexik_translation.translator'] ?? self::getLexikTranslation_TranslatorService($container)));
        }
        $instance->setTranslationDomain('validators');
        $instance->addXmlMappings([(\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/config/validation.xml')]);
        $instance->enableAnnotationMapping(true);
        $instance->setDoctrineAnnotationReader(($container->privates['annotations.cached_reader'] ?? self::getAnnotations_CachedReaderService($container)));
        $instance->addMethodMapping('loadValidatorMetadata');
        $instance->addObjectInitializers([new \Symfony\Bridge\Doctrine\Validator\DoctrineInitializer(($container->services['doctrine'] ?? self::getDoctrineService($container)))]);
        $instance->addLoader(new \Symfony\Component\Validator\Mapping\Loader\PropertyInfoLoader($a, $a, $a, NULL));
        $instance->addLoader(new \Symfony\Bridge\Doctrine\Validator\DoctrineLoader(($container->services['doctrine.orm.default_entity_manager'] ?? self::getDoctrine_Orm_DefaultEntityManagerService($container)), NULL));

        return $instance;
    }

    /**
     * Gets the private 'web_link.add_link_header_listener' shared service.
     *
     * @return \Symfony\Component\WebLink\EventListener\AddLinkHeaderListener
     */
    protected static function getWebLink_AddLinkHeaderListenerService($container)
    {
        return $container->privates['web_link.add_link_header_listener'] = new \Symfony\Component\WebLink\EventListener\AddLinkHeaderListener(($container->privates['web_link.http_header_serializer'] ??= new \Symfony\Component\WebLink\HttpHeaderSerializer()));
    }

    /**
     * Gets the private 'web_link.http_header_serializer' shared service.
     *
     * @return \Symfony\Component\WebLink\HttpHeaderSerializer
     */
    protected static function getWebLink_HttpHeaderSerializerService($container)
    {
        return $container->privates['web_link.http_header_serializer'] = new \Symfony\Component\WebLink\HttpHeaderSerializer();
    }

    /**
     * Gets the private 'webpack_encore.entrypoint_lookup_collection' shared service.
     *
     * @return \Symfony\WebpackEncoreBundle\Asset\EntrypointLookupCollection
     */
    protected static function getWebpackEncore_EntrypointLookupCollectionService($container)
    {
        return $container->privates['webpack_encore.entrypoint_lookup_collection'] = new \Symfony\WebpackEncoreBundle\Asset\EntrypointLookupCollection(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'cms' => ['privates', 'webpack_encore.entrypoint_lookup[cms]', 'getWebpackEncore_EntrypointLookupcmsService', true],
            'portal' => ['privates', 'webpack_encore.entrypoint_lookup[portal]', 'getWebpackEncore_EntrypointLookupportalService', true],
        ], [
            'cms' => '?',
            'portal' => '?',
        ]));
    }

    public function getParameter(string $name): array|bool|string|int|float|\UnitEnum|null
    {
        if (isset($this->buildParameters[$name])) {
            return $this->buildParameters[$name];
        }

        if (!(isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters))) {
            throw new ParameterNotFoundException($name);
        }
        if (isset($this->loadedDynamicParameters[$name])) {
            return $this->loadedDynamicParameters[$name] ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
        }

        return $this->parameters[$name];
    }

    public function hasParameter(string $name): bool
    {
        if (isset($this->buildParameters[$name])) {
            return true;
        }

        return isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters);
    }

    public function setParameter(string $name, $value): void
    {
        throw new LogicException('Impossible to call set() on a frozen ParameterBag.');
    }

    public function getParameterBag(): ParameterBagInterface
    {
        if (null === $this->parameterBag) {
            $parameters = $this->parameters;
            foreach ($this->loadedDynamicParameters as $name => $loaded) {
                $parameters[$name] = $loaded ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
            }
            foreach ($this->buildParameters as $name => $value) {
                $parameters[$name] = $value;
            }
            $this->parameterBag = new FrozenParameterBag($parameters);
        }

        return $this->parameterBag;
    }

    private $loadedDynamicParameters = [
        'kernel.runtime_environment' => false,
        'kernel.build_dir' => false,
        'kernel.cache_dir' => false,
        'mailer_sender_address' => false,
        'mailer_sender_name' => false,
        'admin_activity_time' => false,
        'admin_verify_backup' => false,
        'app.user_reset_request_lifetime' => false,
        'app.user_reset_request_throttle' => false,
        'app.authentication.portal.ttl' => false,
        'app.authentication.portal.verification.token_length' => false,
        'app.recaptcha.private_key' => false,
        'app.recaptcha.enabled' => false,
        'app.api_url' => false,
        'portal_url' => false,
        'kernel.secret' => false,
        'debug.file_link_format' => false,
        'debug.container.dump' => false,
        'router.cache_dir' => false,
        'serializer.mapping.cache.file' => false,
        'validator.mapping.cache.file' => false,
        'doctrine.orm.proxy_dir' => false,
        'scheb_two_factor.email.sender_email' => false,
        'scheb_two_factor.email.sender_name' => false,
        'scheb_two_factor.google.server_name' => false,
        'scheb_two_factor.google.issuer' => false,
        'lexik_jwt_authentication.pass_phrase' => false,
        'lexik_jwt_authentication.token_ttl' => false,
        'lexik_translation.translator.options' => false,
    ];
    private $dynamicParameters = [];

    private function getDynamicParameter(string $name)
    {
        $container = $this;
        $value = match ($name) {
            'kernel.runtime_environment' => $container->getEnv('default:kernel.environment:APP_RUNTIME_ENV'),
            'kernel.build_dir' => $container->targetDir.'',
            'kernel.cache_dir' => $container->targetDir.'',
            'mailer_sender_address' => $container->getEnv('MAILER_SENDER_ADDRESS'),
            'mailer_sender_name' => $container->getEnv('MAILER_SENDER_NAME'),
            'admin_activity_time' => $container->getEnv('ADMIN_ACTIVITY_TIME'),
            'admin_verify_backup' => $container->getEnv('ADMIN_VERIFY_BACKUP'),
            'app.user_reset_request_lifetime' => $container->getEnv('APP_USER_RESET_REQUEST_LIFETIME'),
            'app.user_reset_request_throttle' => $container->getEnv('APP_USER_RESET_REQUEST_THROTTLE'),
            'app.authentication.portal.ttl' => $container->getEnv('APP_AUTHENTICATION_PORTAL_TTL'),
            'app.authentication.portal.verification.token_length' => $container->getEnv('APP_AUTHENTICATION_PORTAL_VERIFICATION_TOKEN_LENGTH'),
            'app.recaptcha.private_key' => $container->getEnv('resolve:GOOGLE_RECAPTCHA_SECRET_KEY'),
            'app.recaptcha.enabled' => $container->getEnv('bool:resolve:GOOGLE_RECAPTCHA_ENABLED'),
            'app.api_url' => $container->getEnv('API_URL'),
            'portal_url' => $container->getEnv('resolve:PORTAL_URL'),
            'kernel.secret' => $container->getEnv('APP_SECRET'),
            'debug.file_link_format' => $container->getEnv('default::SYMFONY_IDE'),
            'debug.container.dump' => ($container->targetDir.''.'/App_KernelProdDebugContainer.xml'),
            'router.cache_dir' => $container->targetDir.'',
            'serializer.mapping.cache.file' => ($container->targetDir.''.'/serialization.php'),
            'validator.mapping.cache.file' => ($container->targetDir.''.'/validation.php'),
            'doctrine.orm.proxy_dir' => ($container->targetDir.''.'/doctrine/orm/Proxies'),
            'scheb_two_factor.email.sender_email' => $container->getEnv('MAILER_SENDER_ADDRESS'),
            'scheb_two_factor.email.sender_name' => $container->getEnv('MAILER_SENDER_NAME'),
            'scheb_two_factor.google.server_name' => $container->getEnv('MAILER_SENDER_NAME'),
            'scheb_two_factor.google.issuer' => $container->getEnv('MAILER_SENDER_NAME'),
            'lexik_jwt_authentication.pass_phrase' => $container->getEnv('JWT_PASSPHRASE'),
            'lexik_jwt_authentication.token_ttl' => $container->getEnv('APP_AUTHENTICATION_PORTAL_TTL'),
            'lexik_translation.translator.options' => [
                'cache_dir' => ($container->targetDir.''.'/translations'),
                'debug' => true,
            ],
            default => throw new ParameterNotFoundException($name),
        };
        $this->loadedDynamicParameters[$name] = true;

        return $this->dynamicParameters[$name] = $value;
    }

    protected function getDefaultParameters(): array
    {
        return [
            'kernel.project_dir' => \dirname(__DIR__, 4),
            'kernel.environment' => 'prod',
            'kernel.debug' => true,
            'kernel.logs_dir' => (\dirname(__DIR__, 3).'/log'),
            'kernel.bundles' => [
                'FrameworkBundle' => 'Symfony\\Bundle\\FrameworkBundle\\FrameworkBundle',
                'DoctrineBundle' => 'Doctrine\\Bundle\\DoctrineBundle\\DoctrineBundle',
                'DoctrineMigrationsBundle' => 'Doctrine\\Bundle\\MigrationsBundle\\DoctrineMigrationsBundle',
                'TwigBundle' => 'Symfony\\Bundle\\TwigBundle\\TwigBundle',
                'TwigExtraBundle' => 'Twig\\Extra\\TwigExtraBundle\\TwigExtraBundle',
                'SecurityBundle' => 'Symfony\\Bundle\\SecurityBundle\\SecurityBundle',
                'MonologBundle' => 'Symfony\\Bundle\\MonologBundle\\MonologBundle',
                'SchebTwoFactorBundle' => 'Scheb\\TwoFactorBundle\\SchebTwoFactorBundle',
                'SymfonyCastsResetPasswordBundle' => 'SymfonyCasts\\Bundle\\ResetPassword\\SymfonyCastsResetPasswordBundle',
                'DataTablesBundle' => 'Omines\\DataTablesBundle\\DataTablesBundle',
                'A2lixAutoFormBundle' => 'A2lix\\AutoFormBundle\\A2lixAutoFormBundle',
                'A2lixTranslationFormBundle' => 'A2lix\\TranslationFormBundle\\A2lixTranslationFormBundle',
                'WebpackEncoreBundle' => 'Symfony\\WebpackEncoreBundle\\WebpackEncoreBundle',
                'AutocompleteBundle' => 'Symfony\\UX\\Autocomplete\\AutocompleteBundle',
                'ChartjsBundle' => 'Symfony\\UX\\Chartjs\\ChartjsBundle',
                'StofDoctrineExtensionsBundle' => 'Stof\\DoctrineExtensionsBundle\\StofDoctrineExtensionsBundle',
                'LexikJWTAuthenticationBundle' => 'Lexik\\Bundle\\JWTAuthenticationBundle\\LexikJWTAuthenticationBundle',
                'KnpUOAuth2ClientBundle' => 'KnpU\\OAuth2ClientBundle\\KnpUOAuth2ClientBundle',
                'GesdinetJWTRefreshTokenBundle' => 'Gesdinet\\JWTRefreshTokenBundle\\GesdinetJWTRefreshTokenBundle',
                'KnpGaufretteBundle' => 'Knp\\Bundle\\GaufretteBundle\\KnpGaufretteBundle',
                'LexikTranslationBundle' => 'Lexik\\Bundle\\TranslationBundle\\LexikTranslationBundle',
                'StimulusBundle' => 'Symfony\\UX\\StimulusBundle\\StimulusBundle',
                'SentryBundle' => 'Sentry\\SentryBundle\\SentryBundle',
                'ArkounayUxCollectionBundle' => 'Arkounay\\Bundle\\UxCollectionBundle\\ArkounayUxCollectionBundle',
                'ArtgrisFileManagerBundle' => 'Artgris\\Bundle\\FileManagerBundle\\ArtgrisFileManagerBundle',
                'ArkounayUxMediaBundle' => 'Arkounay\\Bundle\\UxMediaBundle\\ArkounayUxMediaBundle',
                'KnpPaginatorBundle' => 'Knp\\Bundle\\PaginatorBundle\\KnpPaginatorBundle',
                'TwigComponentBundle' => 'Symfony\\UX\\TwigComponent\\TwigComponentBundle',
                'LiveComponentBundle' => 'Symfony\\UX\\LiveComponent\\LiveComponentBundle',
                'TurboBundle' => 'Symfony\\UX\\Turbo\\TurboBundle',
            ],
            'kernel.bundles_metadata' => [
                'FrameworkBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/framework-bundle'),
                    'namespace' => 'Symfony\\Bundle\\FrameworkBundle',
                ],
                'DoctrineBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle'),
                    'namespace' => 'Doctrine\\Bundle\\DoctrineBundle',
                ],
                'DoctrineMigrationsBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-migrations-bundle'),
                    'namespace' => 'Doctrine\\Bundle\\MigrationsBundle',
                ],
                'TwigBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/twig-bundle'),
                    'namespace' => 'Symfony\\Bundle\\TwigBundle',
                ],
                'TwigExtraBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/twig/extra-bundle'),
                    'namespace' => 'Twig\\Extra\\TwigExtraBundle',
                ],
                'SecurityBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/security-bundle'),
                    'namespace' => 'Symfony\\Bundle\\SecurityBundle',
                ],
                'MonologBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/monolog-bundle'),
                    'namespace' => 'Symfony\\Bundle\\MonologBundle',
                ],
                'SchebTwoFactorBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle'),
                    'namespace' => 'Scheb\\TwoFactorBundle',
                ],
                'SymfonyCastsResetPasswordBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfonycasts/reset-password-bundle/src'),
                    'namespace' => 'SymfonyCasts\\Bundle\\ResetPassword',
                ],
                'DataTablesBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/omines/datatables-bundle/src'),
                    'namespace' => 'Omines\\DataTablesBundle',
                ],
                'A2lixAutoFormBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/a2lix/auto-form-bundle/src'),
                    'namespace' => 'A2lix\\AutoFormBundle',
                ],
                'A2lixTranslationFormBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/a2lix/translation-form-bundle/src'),
                    'namespace' => 'A2lix\\TranslationFormBundle',
                ],
                'WebpackEncoreBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/webpack-encore-bundle/src'),
                    'namespace' => 'Symfony\\WebpackEncoreBundle',
                ],
                'AutocompleteBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/ux-autocomplete'),
                    'namespace' => 'Symfony\\UX\\Autocomplete',
                ],
                'ChartjsBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/ux-chartjs'),
                    'namespace' => 'Symfony\\UX\\Chartjs',
                ],
                'StofDoctrineExtensionsBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/stof/doctrine-extensions-bundle/src'),
                    'namespace' => 'Stof\\DoctrineExtensionsBundle',
                ],
                'LexikJWTAuthenticationBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/lexik/jwt-authentication-bundle'),
                    'namespace' => 'Lexik\\Bundle\\JWTAuthenticationBundle',
                ],
                'KnpUOAuth2ClientBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/knpuniversity/oauth2-client-bundle/src'),
                    'namespace' => 'KnpU\\OAuth2ClientBundle',
                ],
                'GesdinetJWTRefreshTokenBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/gesdinet/jwt-refresh-token-bundle'),
                    'namespace' => 'Gesdinet\\JWTRefreshTokenBundle',
                ],
                'KnpGaufretteBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-gaufrette-bundle'),
                    'namespace' => 'Knp\\Bundle\\GaufretteBundle',
                ],
                'LexikTranslationBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/lexik/translation-bundle'),
                    'namespace' => 'Lexik\\Bundle\\TranslationBundle',
                ],
                'StimulusBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/stimulus-bundle'),
                    'namespace' => 'Symfony\\UX\\StimulusBundle',
                ],
                'SentryBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/sentry/sentry-symfony/src'),
                    'namespace' => 'Sentry\\SentryBundle',
                ],
                'ArkounayUxCollectionBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/arkounay/ux-collection'),
                    'namespace' => 'Arkounay\\Bundle\\UxCollectionBundle',
                ],
                'ArtgrisFileManagerBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/artgris/filemanager-bundle'),
                    'namespace' => 'Artgris\\Bundle\\FileManagerBundle',
                ],
                'ArkounayUxMediaBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/arkounay/ux-media'),
                    'namespace' => 'Arkounay\\Bundle\\UxMediaBundle',
                ],
                'KnpPaginatorBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle'),
                    'namespace' => 'Knp\\Bundle\\PaginatorBundle',
                ],
                'TwigComponentBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/ux-twig-component'),
                    'namespace' => 'Symfony\\UX\\TwigComponent',
                ],
                'LiveComponentBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/ux-live-component'),
                    'namespace' => 'Symfony\\UX\\LiveComponent',
                ],
                'TurboBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/ux-turbo'),
                    'namespace' => 'Symfony\\UX\\Turbo',
                ],
            ],
            'kernel.charset' => 'UTF-8',
            'kernel.container_class' => 'App_KernelProdDebugContainer',
            'app.view.anonymize_exception' => false,
            'locale' => 'hu',
            'default_locale' => 'hu',
            'enabled_locales' => [
                0 => 'hu',
            ],
            'app' => [
                'supported_locales' => [
                    0 => 'hu',
                ],
            ],
            'doctrine_translatable_fetch_mode' => 'LAZY',
            'doctrine_translation_fetch_mode' => 'LAZY',
            'event_dispatcher.event_aliases' => [
                'Symfony\\Component\\Console\\Event\\ConsoleCommandEvent' => 'console.command',
                'Symfony\\Component\\Console\\Event\\ConsoleErrorEvent' => 'console.error',
                'Symfony\\Component\\Console\\Event\\ConsoleSignalEvent' => 'console.signal',
                'Symfony\\Component\\Console\\Event\\ConsoleTerminateEvent' => 'console.terminate',
                'Symfony\\Component\\Form\\Event\\PreSubmitEvent' => 'form.pre_submit',
                'Symfony\\Component\\Form\\Event\\SubmitEvent' => 'form.submit',
                'Symfony\\Component\\Form\\Event\\PostSubmitEvent' => 'form.post_submit',
                'Symfony\\Component\\Form\\Event\\PreSetDataEvent' => 'form.pre_set_data',
                'Symfony\\Component\\Form\\Event\\PostSetDataEvent' => 'form.post_set_data',
                'Symfony\\Component\\HttpKernel\\Event\\ControllerArgumentsEvent' => 'kernel.controller_arguments',
                'Symfony\\Component\\HttpKernel\\Event\\ControllerEvent' => 'kernel.controller',
                'Symfony\\Component\\HttpKernel\\Event\\ResponseEvent' => 'kernel.response',
                'Symfony\\Component\\HttpKernel\\Event\\FinishRequestEvent' => 'kernel.finish_request',
                'Symfony\\Component\\HttpKernel\\Event\\RequestEvent' => 'kernel.request',
                'Symfony\\Component\\HttpKernel\\Event\\ViewEvent' => 'kernel.view',
                'Symfony\\Component\\HttpKernel\\Event\\ExceptionEvent' => 'kernel.exception',
                'Symfony\\Component\\HttpKernel\\Event\\TerminateEvent' => 'kernel.terminate',
                'Symfony\\Component\\Workflow\\Event\\GuardEvent' => 'workflow.guard',
                'Symfony\\Component\\Workflow\\Event\\LeaveEvent' => 'workflow.leave',
                'Symfony\\Component\\Workflow\\Event\\TransitionEvent' => 'workflow.transition',
                'Symfony\\Component\\Workflow\\Event\\EnterEvent' => 'workflow.enter',
                'Symfony\\Component\\Workflow\\Event\\EnteredEvent' => 'workflow.entered',
                'Symfony\\Component\\Workflow\\Event\\CompletedEvent' => 'workflow.completed',
                'Symfony\\Component\\Workflow\\Event\\AnnounceEvent' => 'workflow.announce',
                'Symfony\\Component\\Security\\Core\\Event\\AuthenticationSuccessEvent' => 'security.authentication.success',
                'Symfony\\Component\\Security\\Http\\Event\\InteractiveLoginEvent' => 'security.interactive_login',
                'Symfony\\Component\\Security\\Http\\Event\\SwitchUserEvent' => 'security.switch_user',
            ],
            'fragment.renderer.hinclude.global_template' => NULL,
            'fragment.path' => '/_fragment',
            'kernel.http_method_override' => false,
            'kernel.trust_x_sendfile_type_header' => false,
            'kernel.trusted_hosts' => [

            ],
            'kernel.default_locale' => 'hu',
            'kernel.enabled_locales' => [
                0 => 'hu',
            ],
            'kernel.error_controller' => 'error_controller',
            'asset.request_context.base_path' => NULL,
            'asset.request_context.secure' => NULL,
            'translator.logging' => false,
            'translator.default_path' => (\dirname(__DIR__, 4).'/translations'),
            'debug.error_handler.throw_at' => -1,
            'router.request_context.host' => 'localhost',
            'router.request_context.scheme' => 'http',
            'router.request_context.base_url' => '',
            'router.resource' => 'kernel::loadRoutes',
            'request_listener.http_port' => 80,
            'request_listener.https_port' => 443,
            'session.metadata.storage_key' => '_sf2_meta',
            'session.storage.options' => [
                'cache_limiter' => '0',
                'cookie_secure' => 'auto',
                'cookie_httponly' => true,
                'cookie_samesite' => 'lax',
                'gc_probability' => 1,
            ],
            'session.save_path' => NULL,
            'session.metadata.update_threshold' => 0,
            'form.type_extension.csrf.enabled' => true,
            'form.type_extension.csrf.field_name' => '_token',
            'validator.translation_domain' => 'validators',
            'data_collector.templates' => [

            ],
            'doctrine.dbal.configuration.class' => 'Doctrine\\DBAL\\Configuration',
            'doctrine.data_collector.class' => 'Doctrine\\Bundle\\DoctrineBundle\\DataCollector\\DoctrineDataCollector',
            'doctrine.dbal.connection.event_manager.class' => 'Symfony\\Bridge\\Doctrine\\ContainerAwareEventManager',
            'doctrine.dbal.connection_factory.class' => 'Doctrine\\Bundle\\DoctrineBundle\\ConnectionFactory',
            'doctrine.dbal.events.mysql_session_init.class' => 'Doctrine\\DBAL\\Event\\Listeners\\MysqlSessionInit',
            'doctrine.dbal.events.oracle_session_init.class' => 'Doctrine\\DBAL\\Event\\Listeners\\OracleSessionInit',
            'doctrine.class' => 'Doctrine\\Bundle\\DoctrineBundle\\Registry',
            'doctrine.entity_managers' => [
                'default' => 'doctrine.orm.default_entity_manager',
            ],
            'doctrine.default_entity_manager' => 'default',
            'doctrine.dbal.connection_factory.types' => [
                'uuid' => [
                    'class' => 'Symfony\\Bridge\\Doctrine\\Types\\UuidType',
                ],
                'ulid' => [
                    'class' => 'Symfony\\Bridge\\Doctrine\\Types\\UlidType',
                ],
            ],
            'doctrine.connections' => [
                'default' => 'doctrine.dbal.default_connection',
            ],
            'doctrine.default_connection' => 'default',
            'doctrine.orm.configuration.class' => 'Doctrine\\ORM\\Configuration',
            'doctrine.orm.entity_manager.class' => 'Doctrine\\ORM\\EntityManager',
            'doctrine.orm.manager_configurator.class' => 'Doctrine\\Bundle\\DoctrineBundle\\ManagerConfigurator',
            'doctrine.orm.cache.array.class' => 'Doctrine\\Common\\Cache\\ArrayCache',
            'doctrine.orm.cache.apc.class' => 'Doctrine\\Common\\Cache\\ApcCache',
            'doctrine.orm.cache.memcache.class' => 'Doctrine\\Common\\Cache\\MemcacheCache',
            'doctrine.orm.cache.memcache_host' => 'localhost',
            'doctrine.orm.cache.memcache_port' => 11211,
            'doctrine.orm.cache.memcache_instance.class' => 'Memcache',
            'doctrine.orm.cache.memcached.class' => 'Doctrine\\Common\\Cache\\MemcachedCache',
            'doctrine.orm.cache.memcached_host' => 'localhost',
            'doctrine.orm.cache.memcached_port' => 11211,
            'doctrine.orm.cache.memcached_instance.class' => 'Memcached',
            'doctrine.orm.cache.redis.class' => 'Doctrine\\Common\\Cache\\RedisCache',
            'doctrine.orm.cache.redis_host' => 'localhost',
            'doctrine.orm.cache.redis_port' => 6379,
            'doctrine.orm.cache.redis_instance.class' => 'Redis',
            'doctrine.orm.cache.xcache.class' => 'Doctrine\\Common\\Cache\\XcacheCache',
            'doctrine.orm.cache.wincache.class' => 'Doctrine\\Common\\Cache\\WinCacheCache',
            'doctrine.orm.cache.zenddata.class' => 'Doctrine\\Common\\Cache\\ZendDataCache',
            'doctrine.orm.metadata.driver_chain.class' => 'Doctrine\\Persistence\\Mapping\\Driver\\MappingDriverChain',
            'doctrine.orm.metadata.annotation.class' => 'Doctrine\\ORM\\Mapping\\Driver\\AnnotationDriver',
            'doctrine.orm.metadata.xml.class' => 'Doctrine\\ORM\\Mapping\\Driver\\SimplifiedXmlDriver',
            'doctrine.orm.metadata.yml.class' => 'Doctrine\\ORM\\Mapping\\Driver\\SimplifiedYamlDriver',
            'doctrine.orm.metadata.php.class' => 'Doctrine\\ORM\\Mapping\\Driver\\PHPDriver',
            'doctrine.orm.metadata.staticphp.class' => 'Doctrine\\ORM\\Mapping\\Driver\\StaticPHPDriver',
            'doctrine.orm.metadata.attribute.class' => 'Doctrine\\ORM\\Mapping\\Driver\\AttributeDriver',
            'doctrine.orm.proxy_cache_warmer.class' => 'Symfony\\Bridge\\Doctrine\\CacheWarmer\\ProxyCacheWarmer',
            'form.type_guesser.doctrine.class' => 'Symfony\\Bridge\\Doctrine\\Form\\DoctrineOrmTypeGuesser',
            'doctrine.orm.validator.unique.class' => 'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator',
            'doctrine.orm.validator_initializer.class' => 'Symfony\\Bridge\\Doctrine\\Validator\\DoctrineInitializer',
            'doctrine.orm.security.user.provider.class' => 'Symfony\\Bridge\\Doctrine\\Security\\User\\EntityUserProvider',
            'doctrine.orm.listeners.resolve_target_entity.class' => 'Doctrine\\ORM\\Tools\\ResolveTargetEntityListener',
            'doctrine.orm.listeners.attach_entity_listeners.class' => 'Doctrine\\ORM\\Tools\\AttachEntityListenersListener',
            'doctrine.orm.naming_strategy.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultNamingStrategy',
            'doctrine.orm.naming_strategy.underscore.class' => 'Doctrine\\ORM\\Mapping\\UnderscoreNamingStrategy',
            'doctrine.orm.quote_strategy.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultQuoteStrategy',
            'doctrine.orm.quote_strategy.ansi.class' => 'Doctrine\\ORM\\Mapping\\AnsiQuoteStrategy',
            'doctrine.orm.entity_listener_resolver.class' => 'Doctrine\\Bundle\\DoctrineBundle\\Mapping\\ContainerEntityListenerResolver',
            'doctrine.orm.second_level_cache.default_cache_factory.class' => 'Doctrine\\ORM\\Cache\\DefaultCacheFactory',
            'doctrine.orm.second_level_cache.default_region.class' => 'Doctrine\\ORM\\Cache\\Region\\DefaultRegion',
            'doctrine.orm.second_level_cache.filelock_region.class' => 'Doctrine\\ORM\\Cache\\Region\\FileLockRegion',
            'doctrine.orm.second_level_cache.logger_chain.class' => 'Doctrine\\ORM\\Cache\\Logging\\CacheLoggerChain',
            'doctrine.orm.second_level_cache.logger_statistics.class' => 'Doctrine\\ORM\\Cache\\Logging\\StatisticsCacheLogger',
            'doctrine.orm.second_level_cache.cache_configuration.class' => 'Doctrine\\ORM\\Cache\\CacheConfiguration',
            'doctrine.orm.second_level_cache.regions_configuration.class' => 'Doctrine\\ORM\\Cache\\RegionsConfiguration',
            'doctrine.orm.auto_generate_proxy_classes' => true,
            'doctrine.orm.enable_lazy_ghost_objects' => false,
            'doctrine.orm.proxy_namespace' => 'Proxies',
            'doctrine.migrations.preferred_em' => NULL,
            'doctrine.migrations.preferred_connection' => NULL,
            'twig.form.resources' => [
                0 => 'form_div_layout.html.twig',
                1 => '@LiveComponent/form_theme.html.twig',
                2 => '@ArkounayUxMedia/ux_media_form_theme.html.twig',
                3 => '@ArkounayUxCollection/ux_collection_form_theme.html.twig',
                4 => '@Autocomplete/autocomplete_form_theme.html.twig',
                5 => 'bootstrap_5_layout.html.twig',
                6 => 'form/custom_types.html.twig',
                7 => '@A2lixTranslationForm/bootstrap_5_layout.html.twig',
            ],
            'twig.default_path' => (\dirname(__DIR__, 4).'/templates'),
            'security.role_hierarchy.roles' => [
                'ROLE_SUPER_ADMIN' => [
                    0 => 'ROLE_ADMIN',
                ],
                'ROLE_ADMIN' => [
                    0 => 'ROLE_USER',
                ],
                'ROLE_USER' => [

                ],
            ],
            'security.access.denied_url' => NULL,
            'security.authentication.manager.erase_credentials' => true,
            'security.authentication.session_strategy.strategy' => 'migrate',
            'security.authentication.hide_user_not_found' => true,
            'security.firewalls' => [
                0 => 'dev',
                1 => 'cms',
            ],
            'monolog.use_microseconds' => true,
            'monolog.swift_mailer.handlers' => [

            ],
            'monolog.handlers_to_channels' => [
                'monolog.handler.console' => [
                    'type' => 'exclusive',
                    'elements' => [
                        0 => 'event',
                        1 => 'doctrine',
                        2 => 'console',
                    ],
                ],
                'monolog.handler.main' => [
                    'type' => 'exclusive',
                    'elements' => [
                        0 => 'event',
                    ],
                ],
            ],
            'scheb_two_factor.model_manager_name' => NULL,
            'scheb_two_factor.security_tokens' => [
                0 => 'Symfony\\Component\\Security\\Core\\Authentication\\Token\\UsernamePasswordToken',
            ],
            'scheb_two_factor.ip_whitelist' => [

            ],
            'scheb_two_factor.email.template' => 'system/security/login/verify.html.twig',
            'scheb_two_factor.email.digits' => 6,
            'scheb_two_factor.google.template' => 'system/security/login/verify.html.twig',
            'scheb_two_factor.google.digits' => 6,
            'scheb_two_factor.google.window' => 1,
            'scheb_two_factor.trusted_device.enabled' => false,
            'datatables.config' => [
                'translation_domain' => 'cms',
                'language_from_cdn' => true,
                'options' => [
                    'lengthMenu' => [
                        0 => 10,
                        1 => 25,
                        2 => 50,
                        3 => 100,
                        4 => 250,
                    ],
                    'pageLength' => 25,
                    'paging' => true,
                    'dom' => '<\'row\' <\'col-sm-12 text-right\' >><\'row\' <\'col-sm-12\' tr>><\'row border-top border-top-dashed\' <\'col-sm-6\'l><\'col-sm-6 text-right\'p>>',
                    'searching' => true,
                    'search' => '#datatableWithSearchInput',
                ],
                'template_parameters' => [
                    'className' => 'js-datatable table align-middle table-row-dashed fs-6 gy-5 dataTable text-gray-600 fw-semibold',
                    'columnFilter' => NULL,
                ],
                'persist_state' => 'fragment',
                'method' => 'POST',
                'template' => '@DataTables/datatable_html.html.twig',
            ],
            'a2lix_translation_form.locale_provider' => 'default',
            'a2lix_translation_form.locales' => [
                0 => 'hu',
            ],
            'a2lix_translation_form.required_locales' => [
                0 => 'hu',
            ],
            'a2lix_translation_form.default_locale' => 'hu',
            'a2lix_translation_form.templating' => '@A2lixTranslationForm/bootstrap_5_layout.html.twig',
            'stof_doctrine_extensions.listener.timestampable.class' => 'Gedmo\\Timestampable\\TimestampableListener',
            'stof_doctrine_extensions.listener.blameable.class' => 'Gedmo\\Blameable\\BlameableListener',
            'stof_doctrine_extensions.event_listener.blame.class' => 'Stof\\DoctrineExtensionsBundle\\EventListener\\BlameListener',
            'stof_doctrine_extensions.listener.softdeleteable.class' => 'Gedmo\\SoftDeleteable\\SoftDeleteableListener',
            'stof_doctrine_extensions.listener.tree.class' => 'Gedmo\\Tree\\TreeListener',
            'stof_doctrine_extensions.listener.sluggable.class' => 'Gedmo\\Sluggable\\SluggableListener',
            'stof_doctrine_extensions.listener.loggable.class' => 'Gedmo\\Loggable\\LoggableListener',
            'stof_doctrine_extensions.event_listener.logger.class' => 'Stof\\DoctrineExtensionsBundle\\EventListener\\LoggerListener',
            'stof_doctrine_extensions.default_locale' => 'hu',
            'stof_doctrine_extensions.translation_fallback' => false,
            'stof_doctrine_extensions.persist_default_translation' => false,
            'stof_doctrine_extensions.skip_translation_on_load' => false,
            'stof_doctrine_extensions.listener.translatable.class' => 'Gedmo\\Translatable\\TranslatableListener',
            'stof_doctrine_extensions.listener.sortable.class' => 'Gedmo\\Sortable\\SortableListener',
            'stof_doctrine_extensions.listener.uploadable.class' => 'Gedmo\\Uploadable\\UploadableListener',
            'stof_doctrine_extensions.listener.reference_integrity.class' => 'Gedmo\\ReferenceIntegrity\\ReferenceIntegrityListener',
            'lexik_jwt_authentication.clock_skew' => 0,
            'lexik_jwt_authentication.user_identity_field' => 'username',
            'lexik_jwt_authentication.allow_no_expiration' => false,
            'lexik_jwt_authentication.user_id_claim' => 'username',
            'lexik_jwt_authentication.encoder.signature_algorithm' => 'RS256',
            'lexik_jwt_authentication.encoder.crypto_engine' => 'openssl',
            'gesdinet_jwt_refresh_token.ttl' => 3600,
            'gesdinet_jwt_refresh_token.ttl_update' => false,
            'gesdinet_jwt_refresh_token.security.firewall' => 'api',
            'gesdinet_jwt_refresh_token.user_provider' => NULL,
            'gesdinet_jwt_refresh_token.user_identity_field' => 'username',
            'gesdinet_jwt_refresh_token.single_use' => true,
            'gesdinet_jwt_refresh_token.token_parameter_name' => 'refresh_token',
            'gesdinet_jwt_refresh_token.doctrine_mappings' => true,
            'gesdinet_jwt_refresh_token.cookie' => [
                'same_site' => 'lax',
                'secure' => false,
                'enabled' => true,
                'path' => '/',
                'domain' => NULL,
                'http_only' => true,
                'remove_token_from_body' => true,
            ],
            'gesdinet_jwt_refresh_token.logout_firewall_context' => 'security.firewall.map.context.api',
            'gesdinet_jwt_refresh_token.return_expiration' => false,
            'gesdinet_jwt_refresh_token.return_expiration_parameter_name' => 'refresh_token_expiration',
            'gesdinet.jwtrefreshtoken.refresh_token.class' => 'App\\Entity\\User\\UserRefreshToken',
            'gesdinet.jwtrefreshtoken.object_manager.id' => 'doctrine.orm.entity_manager',
            'gesdinet.jwtrefreshtoken.user_checker.id' => 'security.user_checker',
            'knp_gaufrette.filesystem_map.class' => 'Knp\\Bundle\\GaufretteBundle\\FilesystemMap',
            'lexik_translation.translator.class' => 'Lexik\\Bundle\\TranslationBundle\\Translation\\Translator',
            'lexik_translation.loader.database.class' => 'Lexik\\Bundle\\TranslationBundle\\Translation\\Loader\\DatabaseLoader',
            'lexik_translation.trans_unit.manager.class' => 'Lexik\\Bundle\\TranslationBundle\\Manager\\TransUnitManager',
            'lexik_translation.file.manager.class' => 'Lexik\\Bundle\\TranslationBundle\\Manager\\FileManager',
            'lexik_translation.locale.manager.class' => 'Lexik\\Bundle\\TranslationBundle\\Manager\\LocaleManager',
            'lexik_translation.importer.file.class' => 'Lexik\\Bundle\\TranslationBundle\\Translation\\Importer\\FileImporter',
            'lexik_translation.exporter_collector.class' => 'Lexik\\Bundle\\TranslationBundle\\Translation\\Exporter\\ExporterCollector',
            'lexik_translation.exporter.xliff.class' => 'Lexik\\Bundle\\TranslationBundle\\Translation\\Exporter\\XliffExporter',
            'lexik_translation.exporter.json.class' => 'Lexik\\Bundle\\TranslationBundle\\Translation\\Exporter\\JsonExporter',
            'lexik_translation.exporter.yml.class' => 'Lexik\\Bundle\\TranslationBundle\\Translation\\Exporter\\YamlExporter',
            'lexik_translation.exporter.php.class' => 'Lexik\\Bundle\\TranslationBundle\\Translation\\Exporter\\PhpExporter',
            'lexik_translation.orm.translation_storage.class' => 'Lexik\\Bundle\\TranslationBundle\\Storage\\DoctrineORMStorage',
            'lexik_translation.orm.listener.class' => 'Lexik\\Bundle\\TranslationBundle\\Storage\\Listener\\DoctrineORMListener',
            'lexik_translation.orm.trans_unit.class' => 'Lexik\\Bundle\\TranslationBundle\\Entity\\TransUnit',
            'lexik_translation.orm.translation.class' => 'Lexik\\Bundle\\TranslationBundle\\Entity\\Translation',
            'lexik_translation.orm.file.class' => 'Lexik\\Bundle\\TranslationBundle\\Entity\\File',
            'lexik_translation.mongodb.translation_storage.class' => 'Lexik\\Bundle\\TranslationBundle\\Storage\\DoctrineMongoDBStorage',
            'lexik_translation.mongodb.trans_unit.class' => 'Lexik\\Bundle\\TranslationBundle\\Document\\TransUnit',
            'lexik_translation.mongodb.translation.class' => 'Lexik\\Bundle\\TranslationBundle\\Document\\Translation',
            'lexik_translation.mongodb.file.class' => 'Lexik\\Bundle\\TranslationBundle\\Document\\File',
            'lexik_translation.propel.translation_storage.class' => 'Lexik\\Bundle\\TranslationBundle\\Storage\\PropelStorage',
            'lexik_translation.propel.trans_unit.class' => 'Lexik\\Bundle\\TranslationBundle\\Propel\\TransUnit',
            'lexik_translation.propel.translation.class' => 'Lexik\\Bundle\\TranslationBundle\\Propel\\Translation',
            'lexik_translation.propel.file.class' => 'Lexik\\Bundle\\TranslationBundle\\Propel\\File',
            'lexik_translation.data_grid.formatter.class' => 'Lexik\\Bundle\\TranslationBundle\\Util\\DataGrid\\DataGridFormatter',
            'lexik_translation.data_grid.request_handler.class' => 'Lexik\\Bundle\\TranslationBundle\\Util\\DataGrid\\DataGridRequestHandler',
            'lexik_translation.overview.stats_aggregator.class' => 'Lexik\\Bundle\\TranslationBundle\\Util\\Overview\\StatsAggregator',
            'lexik_translation.form.handler.trans_unit.class' => 'Lexik\\Bundle\\TranslationBundle\\Form\\Handler\\TransUnitFormHandler',
            'lexik_translation.listener.get_database_resources.class' => 'Lexik\\Bundle\\TranslationBundle\\EventDispatcher\\GetDatabaseResourcesListener',
            'lexik_translation.listener.clean_translation_cache.class' => 'Lexik\\Bundle\\TranslationBundle\\EventDispatcher\\CleanTranslationCacheListener',
            'lexik_translation.token_finder.class' => 'Lexik\\Bundle\\TranslationBundle\\Util\\Profiler\\TokenFinder',
            'lexik_translation.command.import_translations.class' => 'Lexik\\Bundle\\TranslationBundle\\Command\\ImportTranslationsCommand',
            'lexik_translation.command.export_translations.class' => 'Lexik\\Bundle\\TranslationBundle\\Command\\ExportTranslationsCommand',
            'lexik_translation.controller.translation.class' => 'Lexik\\Bundle\\TranslationBundle\\Controller\\TranslationController',
            'lexik_translation.controller.rest.class' => 'Lexik\\Bundle\\TranslationBundle\\Controller\\RestController',
            'lexik_translation.importer.case_insensitive' => false,
            'lexik_translation.token_finder.limit' => 15,
            'lexik_translation.managed_locales' => [
                0 => 'hu',
            ],
            'lexik_translation.fallback_locale' => [
                0 => 'hu',
            ],
            'lexik_translation.storage' => [
                'type' => 'orm',
            ],
            'lexik_translation.base_layout' => '@LexikTranslationBundle/layout.html.twig',
            'lexik_translation.grid_input_type' => 'text',
            'lexik_translation.grid_toggle_similar' => false,
            'lexik_translation.auto_cache_clean' => false,
            'lexik_translation.dev_tools.enable' => false,
            'lexik_translation.dev_tools.create_missing' => false,
            'lexik_translation.dev_tools.file_format' => 'yml',
            'lexik_translation.exporter.json.hierarchical_format' => false,
            'lexik_translation.exporter.yml.use_tree' => false,
            'lexik_translation.storage.type' => 'orm',
            'sentry.tracing.enabled' => true,
            'sentry.tracing.dbal.enabled' => true,
            'sentry.tracing.dbal.connections' => [

            ],
            'sentry.tracing.cache.enabled' => true,
            'sentry.tracing.http_client.enabled' => true,
            'artgris_file_manager' => [
                'conf' => [
                    'default' => [
                        'dir' => (\dirname(__DIR__, 4).'/public/uploads'),
                        'show_file_count' => true,
                        'root_name' => NULL,
                        'cachebreaker' => true,
                        'view' => 'list',
                    ],
                ],
                'web_dir' => (\dirname(__DIR__, 4).'/public'),
            ],
            'ux_media' => [
                'cropped_path' => 'cropped/',
            ],
            'knp_paginator.template.pagination' => '@KnpPaginator/Pagination/bootstrap_v5_pagination.html.twig',
            'knp_paginator.template.filtration' => '@KnpPaginator/Pagination/filtration.html.twig',
            'knp_paginator.template.sortable' => '@KnpPaginator/Pagination/sortable_link.html.twig',
            'knp_paginator.page_range' => 5,
            'knp_paginator.page_limit' => NULL,
            'console.command.ids' => [
                0 => 'console.command.public_alias.Lexik\\Bundle\\TranslationBundle\\Command\\ImportTranslationsCommand',
                1 => 'console.command.public_alias.Lexik\\Bundle\\TranslationBundle\\Command\\ExportTranslationsCommand',
            ],
        ];
    }
}
