<?php

declare(strict_types=1);

/*
 * This file is part of the AutoFormBundle package.
 *
 * (c) David ALLIX <http://a2lix.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace A2lix\AutoFormBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('a2lix_auto_form');
        $rootNode = method_exists(TreeBuilder::class, 'getRootNode') ? $treeBuilder->getRootNode() : $treeBuilder->root('a2lix_auto_form');

        $rootNode
            ->children()
            ->arrayNode('excluded_fields')
            ->defaultValue(['id', 'locale', 'translatable'])
            ->beforeNormalization()
            ->ifString()
            ->then(function ($v) {
                return preg_split('/\s*,\s*/', $v);
            })
            ->end()
            ->prototype('scalar')
            ->info('Global list of fields to exclude from form generation. (Default: id, locale, translatable)')->end()
            ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
