<?php

/*
 * OAuth2 Client Bundle
 * Copyright (c) KnpUniversity <http://knpuniversity.com/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace KnpU\OAuth2ClientBundle\DependencyInjection\Providers;

use KnpU\OAuth2ClientBundle\Client\Provider\CleverClient;
use Symfony\Component\Config\Definition\Builder\NodeBuilder;

class CleverProviderConfigurator implements ProviderConfiguratorInterface
{
    public function buildConfiguration(NodeBuilder $node)
    {
        // no custom options
    }

    public function getProviderClass(array $config)
    {
        return 'Schoolrunner\OAuth2\Client\Provider\Clever';
    }

    public function getProviderOptions(array $config)
    {
        return [
            'clientId' => $config['client_id'],
            'clientSecret' => $config['client_secret'],
        ];
    }

    public function getPackagistName()
    {
        return 'schoolrunner/oauth2-clever';
    }

    public function getLibraryHomepage()
    {
        return 'https://github.com/schoolrunner/oauth2-clever';
    }

    public function getProviderDisplayName()
    {
        return 'Clever';
    }

    public function getClientClass(array $config)
    {
        return CleverClient::class;
    }
}
