<?php

/*
 * OAuth2 Client Bundle
 * Copyright (c) KnpUniversity <http://knpuniversity.com/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace KnpU\OAuth2ClientBundle\DependencyInjection\Providers;

use KnpU\OAuth2ClientBundle\Client\Provider\DevianArtClient;
use Symfony\Component\Config\Definition\Builder\NodeBuilder;

class DevianArtProviderConfigurator implements ProviderConfiguratorInterface
{
    public function buildConfiguration(NodeBuilder $node)
    {
        // no custom options
    }

    public function getProviderClass(array $config)
    {
        return 'SeinopSys\OAuth2\Client\Provider\DeviantArtProvider';
    }

    public function getProviderOptions(array $config)
    {
        return [
            'clientId' => $config['client_id'],
            'clientSecret' => $config['client_secret'],
        ];
    }

    public function getPackagistName()
    {
        return 'seinopsys/oauth2-deviantart';
    }

    public function getLibraryHomepage()
    {
        return 'https://github.com/SeinopSys/oauth2-deviantart';
    }

    public function getProviderDisplayName()
    {
        return 'DevianArt';
    }

    public function getClientClass(array $config)
    {
        return DevianArtClient::class;
    }
}
