<?php

/*
 * OAuth2 Client Bundle
 * Copyright (c) KnpUniversity <http://knpuniversity.com/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace KnpU\OAuth2ClientBundle\DependencyInjection\Providers;

use KnpU\OAuth2ClientBundle\Client\Provider\FitbitClient;
use Symfony\Component\Config\Definition\Builder\NodeBuilder;

class FitbitProviderConfigurator implements ProviderConfiguratorInterface
{
    public function buildConfiguration(NodeBuilder $node)
    {
        // no custom options
    }

    public function getProviderClass(array $config)
    {
        return 'djchen\OAuth2\Client\Provider\Fitbit';
    }

    public function getProviderOptions(array $config)
    {
        return [
            'clientId' => $config['client_id'],
            'clientSecret' => $config['client_secret'],
        ];
    }

    public function getPackagistName()
    {
        return 'djchen/oauth2-fitbit';
    }

    public function getLibraryHomepage()
    {
        return 'https://github.com/djchen/oauth2-fitbit';
    }

    public function getProviderDisplayName()
    {
        return 'Fitbit';
    }

    public function getClientClass(array $config)
    {
        return FitbitClient::class;
    }
}
