<?php

/*
 * OAuth2 Client Bundle
 * Copyright (c) KnpUniversity <http://knpuniversity.com/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace KnpU\OAuth2ClientBundle\DependencyInjection\Providers;

use KnpU\OAuth2ClientBundle\Client\Provider\HeadHunterClient;
use Symfony\Component\Config\Definition\Builder\NodeBuilder;

class HeadHunterProviderConfigurator implements ProviderConfiguratorInterface
{
    public function buildConfiguration(NodeBuilder $node)
    {
        // no custom options
    }

    public function getProviderClass(array $config)
    {
        return 'AlexMasterov\OAuth2\Client\Provider\HeadHunter';
    }

    public function getProviderOptions(array $config)
    {
        return [
            'clientId' => $config['client_id'],
            'clientSecret' => $config['client_secret'],
        ];
    }

    public function getPackagistName()
    {
        return 'alexmasterov/oauth2-headhunter';
    }

    public function getLibraryHomepage()
    {
        return 'https://github.com/AlexMasterov/oauth2-headhunter';
    }

    public function getProviderDisplayName()
    {
        return 'HeadHunter';
    }

    public function getClientClass(array $config)
    {
        return HeadHunterClient::class;
    }
}
