<?php

/*
 * OAuth2 Client Bundle
 * Copyright (c) KnpUniversity <http://knpuniversity.com/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace KnpU\OAuth2ClientBundle\DependencyInjection\Providers;

use KnpU\OAuth2ClientBundle\Client\Provider\StripeClient;
use Symfony\Component\Config\Definition\Builder\NodeBuilder;

class StripeProviderConfigurator implements ProviderConfiguratorInterface
{
    public function buildConfiguration(NodeBuilder $node)
    {
        // no custom options
    }

    public function getProviderClass(array $config)
    {
        return 'AdamPaterson\OAuth2\Client\Provider\Stripe';
    }

    public function getProviderOptions(array $config)
    {
        return [
            'clientId' => $config['client_id'],
            'clientSecret' => $config['client_secret'],
        ];
    }

    public function getPackagistName()
    {
        return 'adam-paterson/oauth2-stripe';
    }

    public function getLibraryHomepage()
    {
        return 'https://github.com/adam-paterson/oauth2-stripe';
    }

    public function getProviderDisplayName()
    {
        return 'Stripe';
    }

    public function getClientClass(array $config)
    {
        return StripeClient::class;
    }
}
